<?php

function grogin_add_elementor_page_settings_controls( $page ) {

	$page->add_control( 'grogin_elementor_enable_sidebar_collapse',
		[
			'label'          => esc_html__( 'Sidebar Collapse', 'grogin-core' ),
            'type'           => \Elementor\Controls_Manager::SWITCHER,
			'label_on'       => esc_html__( 'Yes', 'grogin-core' ),
			'label_off'      => esc_html__( 'No', 'grogin-core' ),
			'return_value'   => 'yes',
			'default'        => 'no',
		]
	);

	$page->add_control( 'grogin_elementor_hide_page_header',
		[
			'label'          => esc_html__( 'Hide Header', 'grogin-core' ),
            'type'           => \Elementor\Controls_Manager::SWITCHER,
			'label_on'       => esc_html__( 'Yes', 'grogin-core' ),
			'label_off'      => esc_html__( 'No', 'grogin-core' ),
			'return_value'   => 'yes',
			'default'        => 'no',
		]
	);
	
	$page->add_control( 'grogin_elementor_page_header_type',
		[
			'label' => esc_html__( 'Header Type', 'grogin-core' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'' => esc_html__( 'Select a type', 'grogin-core' ),
				'type1' 	  => esc_html__( 'Type 1', 'grogin-core' ),
				'type2'		  => esc_html__( 'Type 2', 'grogin-core' ),
				'type3'		  => esc_html__( 'Type 3', 'grogin-core' ),
				'type4'		  => esc_html__( 'Type 4', 'grogin-core' ),
				'type5'		  => esc_html__( 'Type 5', 'grogin-core' ),
			],
		]
	);
	
	$page->add_control( 'grogin_elementor_hide_page_footer',
		[
			'label'          => esc_html__( 'Hide Footer', 'grogin-core' ),
			'type'           => \Elementor\Controls_Manager::SWITCHER,
			'label_on'       => esc_html__( 'Yes', 'grogin-core' ),
			'label_off'      => esc_html__( 'No', 'grogin-core' ),
			'return_value'   => 'yes',
			'default'        => 'no',
		]
	);
	
	$page->add_control( 'grogin_elementor_page_footer_type',
		[
			'label' => esc_html__( 'Footer Type', 'grogin-core' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => '',
			'options' => [
				'' => esc_html__( 'Select a type', 'grogin-core' ),
				'type1' 	  => esc_html__( 'Type 1', 'grogin-core' ),
				'type2'		  => esc_html__( 'Type 2', 'grogin-core' ),
			],
		]
	);
	
	$page->add_control( 'grogin_elementor_logo',
		[
			'label'          => esc_html__( 'Set Dark Logo', 'grogin-core' ),
            'type' 			 => \Elementor\Controls_Manager::MEDIA,
		]
	);

	$page->add_control(
		'page_width',
		[
			'label' => __( 'Width', 'grogin-core' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'devices' => [ 'desktop' ],
			'size_units' => [ 'px'],
			'range' => [
				'px' => [
					'min' => 1100,
					'max' => 1650,
					'step' => 5,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 1440,
			],
			'selectors' => [
				'{{WRAPPER}} .container' => 'max-width: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .elementor-section.elementor-section-boxed>.elementor-container' => 'max-width: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .e-con ' => '--container-max-width: {{SIZE}}{{UNIT}};',
			],
		]
	);

}

add_action( 'elementor/element/wp-page/document_settings/before_section_end', 'grogin_add_elementor_page_settings_controls' );