<?php

namespace Elementor;

class Grogin_Home_Slider_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'grogin-home-slider';
    }
    public function get_title() {
        return 'Home Slider (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'slider_type',
			[
				'label' => esc_html__( 'Slider Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'type1'	  => esc_html__( 'Type 1', 'grogin-core' ),
					'type2'	  => esc_html__( 'Type 2', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);

        $this->add_control( 'auto_speed',
            [
                'label' => esc_html__( 'Auto Speed', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '500',
                'pleaceholder' => esc_html__( 'Set auto speed.', 'grogin-core' ),
				'condition' => ['auto_play' => 'true']
            ]
        );
		
		$this->add_control( 'dots',
			[
				'label' => esc_html__( 'Dots', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		
		$this->add_control( 'arrows',
			[
				'label' => esc_html__( 'Arrows', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

        $this->add_control( 'slide_speed',
            [
                'label' => esc_html__( 'Slide Speed', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '600',
                'pleaceholder' => esc_html__( 'Set slide speed.', 'grogin-core' ),
            ]
        );
		
		$defaultbg = plugins_url( 'images/slider-01.jpg', __DIR__ );
		
		$repeater = new Repeater();
        $repeater->add_control( 'slider_image',
            [
                'label' => esc_html__( 'Image', 'grogin-core' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $repeater->add_control( 'slider_title',
            [
                'label' => esc_html__( 'Item Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Oliga makyngen. Nelis. Somonat ohöv. Preng voren dolare.',
                'pleaceholder' => esc_html__( 'Enter item title here.', 'grogin-core' )
            ]
        );
		
        $repeater->add_control( 'slider_subtitle',
            [
                'label' => esc_html__( 'Item Subtitle', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Weekend Discount',
                'pleaceholder' => esc_html__( 'Enter item subtitle here.', 'grogin-core' )
            ]
        );
		
		$repeater->add_control( 'subtitle_type',
			[
				'label' => esc_html__( 'Subtitle Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'type1'	  => esc_html__( 'Type 1', 'grogin-core' ),
					'type2'	  => esc_html__( 'Type 2', 'grogin-core' ),
				],
			]
		);
		
        $repeater->add_control( 'slider_desc',
            [
                'label' => esc_html__( 'Item Description', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Dysplastisk mitredes men kontaktlös kortbetalning. Dystism. Tens nisperade. Trikist redängar inklusive uns. ',
                'pleaceholder' => esc_html__( 'Enter item desc here.', 'grogin-core' )
            ]
        );
		
		$repeater->add_control( 'slider_price_text',
            [
                'label' => esc_html__( 'Item Price Text', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Dont miss this limited time offer.',
                'pleaceholder' => esc_html__( 'Add a price.', 'grogin-core' )
            ]
        );
		
		$repeater->add_control( 'price_text_color',
			[
				'label' => esc_html__( 'Price Text Color', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'dark',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'dark' 	  	  => esc_html__( 'Dark ', 'grogin-core' ),
					'light'	 	  => esc_html__( 'Light ', 'grogin-core' ),
				],
			]
		);
		
		$repeater->add_control( 'slider_regular_price',
            [
                'label' => esc_html__( 'Item Regular Price', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '$26.67',
                'pleaceholder' => esc_html__( 'Add a price.', 'grogin-core' )
            ]
        );
		
		$repeater->add_control( 'slider_sale_price',
            [
                'label' => esc_html__( 'Item Sale Price', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '$21.67',
                'pleaceholder' => esc_html__( 'Add a price.', 'grogin-core' )
            ]
        );

        $repeater->add_control( 'slider_btn_title',
            [
                'label' => esc_html__( 'Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' )
            ]
        );
		
        $repeater->add_control( 'slider_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' )
            ]
        );
		
		$this->add_control( 'slider_items',
            [
                'label' => esc_html__( 'Slide Items', 'grogin-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_image' => ['url' => $defaultbg],
                        'slider_title' => 'Oliga makyngen. Nelis. Somonat ohöv. Preng voren dolare.',
                        'slider_subtitle' => 'Weekend Discount',
                        'slider_desc' => 'Dysplastisk mitredes men kontaktlös kortbetalning. Dystism. Tens nisperade. Trikist redängar inklusive uns. ',
						'slider_price_text' => 'Dont miss this limited time offer.',
						'slider_regular_price' => '$26.67',
						'slider_sale_price' => '$21.67',
                        'slider_btn_title' => ' Shop Now ',
                        'slider_btn_link' => '#',
                    ],
                    [
                        'slider_image' => ['url' => $defaultbg],
                        'slider_title' => 'Oliga makyngen. Nelis. Somonat ohöv. Preng voren dolare.',
                        'slider_subtitle' => 'Weekend Discount',
						'slider_desc' => 'Dysplastisk mitredes men kontaktlös kortbetalning. Dystism. Tens nisperade. Trikist redängar inklusive uns. ',
						'slider_price_text' => 'Dont miss this limited time offer.',
						'slider_regular_price' => '$26.67',
						'slider_sale_price' => '$21.67',
                        'slider_btn_title' => ' Shop Now ',
                        'slider_btn_link' => '#',
                    ],
                ]
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/* Countdown Start*/
		$this->start_controls_section(
			'countdown_section',
			[
				'label' => esc_html__( 'Countdown', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'countdown',
			[
				'label' => esc_html__( 'Countdown', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);
		
		$this->add_control('due_date',
			[
				'label' => esc_html__( 'Due Date', 'grogin-core' ),
				'type' => Controls_Manager::DATE_TIME,
				'default' => '2024/01/15',
				'picker_options' => ['enableTime' => false],
				'condition' => ['countdown' => 'true']
			]
		);
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
        /*****   START CONTROLS SECTION   ******/
		
		$this->start_controls_section('grogin_styling',
            [
                'label' => esc_html__( ' Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_responsive_control( 'home_slider_alignment',
            [
                'label' => esc_html__( 'Alignment', 'grogin-core' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .entry-wrapper' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'grogin-core' ),
                        'icon' => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'grogin-core' ),
                        'icon' => 'eicon-text-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'grogin-core' ),
                        'icon' => 'eicon-text-align-right'
                    ]
                ],
                'toggle' => true,
                
            ]
        );
		
		$this->add_control( 'align_items',
			[
				'label' => esc_html__( 'Align Items', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'center',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'start'	  => esc_html__( 'Start', 'grogin-core' ),
					'center'  => esc_html__( 'Center', 'grogin-core' ),
					'end'	  => esc_html__( 'End', 'grogin-core' ),
				],
			]
		);
		
		$this->add_responsive_control( 'width',
            [
                'label' => esc_html__( 'Width', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content' => 'max-width: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'tablet_height',
            [
                'label' => esc_html__( 'Tablet Height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10000,
                'step' => 1,
                'default' => '220',
            ]
        );
		
		$this->add_responsive_control( 'mobile_height',
            [
                'label' => esc_html__( 'Mobile Height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10000,
                'step' => 1,
                'default' => '200',
            ]
        );
		
		$this->add_responsive_control( 'padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} .entry-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],              
            ]
        );
		
		$this->add_control( 'image_heading',
            [
                'label' => esc_html__( 'IMAGE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} .entry-media img',
			]
		);
		
		$this->add_control( 'title_heading',
            [
                'label' => esc_html__( 'TITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'title_color',
			[
               'label' => esc_html__( 'Title Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-title' => 'color: {{VALUE}} !important;']
			]
        );
		
		$this->add_responsive_control( 'title_size',
            [
                'label' => esc_html__( 'Title Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'title_weight',
            [
                'label' => esc_html__( 'Title Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'title_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'title_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .entry-title',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .entry-body .entry-title',
				
            ]
        );
		
		$this->add_control( 'subtitle_heading',
            [
                'label' => esc_html__( 'SUBTITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'subtitle_color',
           [
               'label' => esc_html__( 'Subtitle Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .banner-badge, {{WRAPPER}} .entry-subtitle' => 'color: {{VALUE}};']
           ]
        );
		
		$this->add_control( 'subtitle_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .banner-badge, {{WRAPPER}} .entry-subtitle ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle_text_shadow',
				'selector' => '{{WRAPPER}} .banner-badge, {{WRAPPER}} .entry-subtitle',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .banner-badge, {{WRAPPER}} .entry-subtitle',
				
            ]
        );
		
		$this->add_control( 'description_heading',
            [
                'label' => esc_html__( 'DESCRIPTION', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'description_color',
			[
               'label' => esc_html__( 'Description Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-content p' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_responsive_control( 'desc_size',
            [
                'label' => esc_html__( 'Description Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'desc_weight',
            [
                'label' => esc_html__( 'Description Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'desc_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'description_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'description_text_shadow',
				'selector' => '{{WRAPPER}} .entry-content p ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .entry-content p',
				
            ]
        );
		
		$this->add_control( 'regular_price_text_heading',
            [
                'label' => esc_html__( 'REGULAR PRICE TEXT', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'regular_price_text_color',
           [
               'label' => esc_html__( 'Price Text Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .price del ' => 'color: {{VALUE}};']
           ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'regular_price_text_shadow',
				'selector' => '{{WRAPPER}} .price del ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'regular_price_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .price del',
				
            ]
        );
		
		$this->add_control( 'sale_price_text_heading',
            [
                'label' => esc_html__( 'SALE PRICE TEXT', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'sale_price_text_color',
           [
               'label' => esc_html__( 'Price Text Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .price ins ' => 'color: {{VALUE}};']
           ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'sale_price_text_shadow',
				'selector' => '{{WRAPPER}} .price ins ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sale_price_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .price ins',
				
            ]
        );
		
		$this->add_control( 'price_description_heading',
            [
                'label' => esc_html__( 'PRICE DESCRIPTION', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'price_description_color',
           [
               'label' => esc_html__( 'Price Description Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .price-description ' => 'color: {{VALUE}};']
           ]
        );
		
		$this->add_control( 'price_description_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .price-description ' => 'opacity: {{VALUE}} !important;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'price_description_shadow',
				'selector' => '{{WRAPPER}} .price-description ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_description_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .price-description',
				
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('btn_styling',
            [
                'label' => esc_html__( ' Button Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} a.btn  '
            ]
        );
		
		$this->add_control( 'btn_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_control( 'btn_color',
            [
                'label' => esc_html__( 'Color', 'grogin-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'color: {{VALUE}};']
            ]
        );
       
	    $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => esc_html__( 'Border', 'grogin-core' ),
                'selector' => '{{WRAPPER}} a.btn ',
            ]
        );
        
		$this->add_responsive_control( 'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],
            ]
        );
		
		$this->add_responsive_control( 'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],              
            ]
        );
       
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'label' => esc_html__( 'Background', 'grogin-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} a.btn',
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if ( $settings['slider_items'] ) {
			
			$sliderype= '';
			
			if($settings['slider_type'] == 'type2'){
				$sliderype .= 'full-width';
			} else {
				$sliderype .= '';
			}
			
			echo '<div class="klb-slider '.esc_attr($sliderype).' site-slider slider-style slider-loading-height loader-default arrows-default arrows-offset" data-speed="'.esc_attr($settings['slide_speed']).'" data-items="1" data-itemScroll="1" data-arrows="'.esc_attr($settings['arrows']).'" data-dots="'.esc_attr($settings['dots']).'" data-autoplay="'.esc_attr($settings['auto_play']).'" data-autospeed="'.esc_attr($settings['auto_speed']).'" data-infinite="true" data-draggable="true">';
		
			foreach ( $settings['slider_items'] as $item ) {
				$target = $item['slider_btn_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $item['slider_btn_link']['nofollow'] ? ' rel="nofollow"' : '';
				
				$aligntype= '';

				if($settings['align_items'] == 'end'){
					$aligntype .= 'end';
				} elseif($settings['align_items'] == 'start'){	
					$aligntype .= 'start';
				} else {
					$aligntype .= 'center';
				}
				
				$pricecolortype= '';
				
				if($item['price_text_color'] == 'light'){
					$pricecolortype .= 'text-white';
				} else {
					$pricecolortype .= '';
				}
				
				$countertype= '';
				
				if($settings['countdown'] == 'true'){
					$countertype .= 'flex-column';
				} else {
					$countertype .= '';
				}

				
				echo '<div class="slider-item">';
				echo '<div class="site-banner overflow-hidden rounded-base" style="--banner-tablet-height: '.esc_attr($settings['tablet_height']).'px; --banner-mobile-height: '.esc_attr($settings['mobile_height']).'px;" data-color="dark">';
				echo '<div class="entry-wrapper '.esc_attr($countertype).' d-flex align-items-'.esc_attr($aligntype).' strech p-20 sm-p-40 lg-p-60">';
				echo '<div class="entry-inner max-w-80 sm-max-w-60 md-max-w-50">';
				echo '<div class="entry-header mb-10">';
				
				if($item['subtitle_type'] == 'type2'){
					echo '<h5 class="entry-subtitle text-13 fw-medium text-blue-900">'.esc_html($item['slider_subtitle']).'</h5>';
				} else {
					echo '<span class="banner-badge green">'.esc_html($item['slider_subtitle']).'</span>';
				}
				
				echo '</div>';
				echo '<div class="entry-body mb-10 sm-mb-24 md-mb-40">';
				echo '<h2 class="entry-title text-26 sm-text-36 md-text-42 fw-bold text-primary-active">'.esc_html($item['slider_title']).'</h2>';
				echo '<div class="entry-content pr-0 md-pr-30">';
				echo '<p class="text-13 sm-text-14 md-text-16 lh-base">'.grogin_sanitize_data($item['slider_desc']).' </p>';
				echo '</div>';
				echo '</div>';
				echo '<div class="entry-footer d-flex flex-wrap align-items-center gap-3">';
				if($item['slider_btn_title']){	
					echo '<a href="'.esc_url($item['slider_btn_link']['url']).'" class="btn btn-primary mobile-small icon-right" '.esc_attr($target.$nofollow).'>'.esc_html($item['slider_btn_title']).' <i class="klb-icon-move-right"></i></a>';
				} 
				echo '<div class="banner-price d-inline-flex flex-column align-items-start">';
				echo '<span class="price">';
				echo '<del aria-hidden="true"><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol"></span>'.esc_html($item['slider_regular_price']).'</bdi></span></del>';
				echo '<ins><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol"></span>'.esc_html($item['slider_sale_price']).'</bdi></span></ins>';
				echo '</span>';
				echo '<span class="d-block price-description text-11 opacity-50 '.esc_attr($pricecolortype).'">'.esc_html($item['slider_price_text']).'</span>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
				
				if($settings['countdown'] == 'true'){
					echo '<div class="entry-counter">';
					echo '<div class="banner-countdown d-flex flex-wrap align-items-center gap-3">';
					
					$date = date_create($settings['due_date']);
					echo '<div class="site-countdown dark d-inline-flex flex-wrap align-items-center gap-1" data-date="'.esc_attr(date_format($date,"Y/m/d")).'" data-text="'.esc_attr__('Expired','grogin-core').'">';
					echo '<div class="countdown-item d-inline-flex align-items-center lh-1">';
					echo '<div class="days text-12"></div>';
					echo '</div><!-- countdown-item -->';
					echo '<div class="countdown-item d-inline-flex align-items-center lh-1">';
					echo '<div class="hours text-12"></div>';
					echo '</div><!-- countdown-item -->';
					echo '<div class="countdown-item d-inline-flex align-items-center lh-1">';
					echo '<div class="minutes text-12"></div>';
					echo '</div><!-- countdown-item -->';
					echo '<span class="countdown-separator">:</span>';
					echo '<div class="countdown-item d-inline-flex align-items-center lh-1">';
					echo '<div class="second text-12"></div>';
					echo '</div><!-- countdown-item -->';
					echo '</div><!-- site-countdown -->';
					echo '<p class="text-11 text-gray-500 mb-0">'.esc_html__('Remains until the end of the offer', 'grogin-core').'</p>';
					echo '</div><!-- banner-countdown -->';
					echo '</div><!-- entry-counter -->';
				}
				
				echo '</div>';
				echo '<div class="entry-media">';
				echo '<img src="'.esc_url($item['slider_image']['url']).'" alt="">';
				echo '</div>';
				echo '<a href="'.esc_url($item['slider_btn_link']['url']).'" '.esc_attr($target.$nofollow).' class="overlay-link"></a>';
				echo '</div>';
				echo '</div>';
			}
			echo '</div>';  
		}
		
	}

}