<?php

namespace Elementor;

class Grogin_Product_Carousel_Widget extends Widget_Base {
    use Grogin_Helper;

    public function get_name() {
        return 'grogin-product-carousel';
    }
    public function get_title() {
        return 'Product Carousel (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'content_type',
			[
				'label' => esc_html__( 'Content Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' 	=> esc_html__( 'Select Type', 'grogin-core' ),
					'type1' 	=> esc_html__( 'Style 1', 'grogin-core' ),
					'type2'		=> esc_html__( 'Style 2', 'grogin-core' ),
				],
			]
		);

		$this->add_control( 'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);
		
        $this->add_control( 'auto_speed',
            [
                'label' => esc_html__( 'Auto Speed', 'chakta' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '1600',
                'pleaceholder' => esc_html__( 'Set auto speed.', 'chakta' ),
				'condition' => ['auto_play' => 'true']
            ]
        );
		
		$this->add_control( 'dots',
			[
				'label' => esc_html__( 'Dots', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);
		
		$this->add_control( 'arrows',
			[
				'label' => esc_html__( 'Arrows', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

        $this->add_control( 'slide_speed',
            [
                'label' => esc_html__( 'Slide Speed', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '1200',
                'pleaceholder' => esc_html__( 'Set slide speed.', 'grogin-core' ),
            ]
        );

		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/***** START QUERY CONTROLS SECTION *****/
		$this->grogin_query_elementor_controls($post_count = 8, $column = 6, $carousel = 'yes');
		/***** END QUERY CONTROLS SECTION *****/
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
	
		$output = '';
		
		$contenttype = '';
		
		if($settings['content_type'] == 'type2'){
			$contenttype .= 'border-red';
		} else {
			$contenttype .= '';
		}
		
		$output .= '<div class="site-module">';
		$output .= '<div class="site-module-body">'; 
		$output .= '<div class="site-slider carousel-style slider-loading-height loader-default arrows-filled filled-white arrows-scale products border '.esc_attr($contenttype).'" data-speed="'.esc_attr($settings['slide_speed']).'" data-items="'.esc_attr($settings['column']).'" data-itemsTablet="'.esc_attr($settings['tablet_column']).'" data-itemsMobile="'.esc_attr($settings['mobile_column']).'" data-autoplay="'.esc_attr($settings['auto_play']).'" data-autospeed="'.esc_attr($settings['auto_speed']).'" data-itemScroll="1" data-arrows="'.esc_attr($settings['arrows']).'" data-dots="'.esc_attr($settings['dots']).'" data-infinite="true" data-draggable="true">';
		$output .= $this->grogin_elementor_product_loop($settings, $productslider = 'yes');		
		$output .= '</div><!-- site-slider -->';
		$output .= '</div><!-- site-module-body -->';
		$output .= '</div><!-- site-module -->  ';

		echo $output;
	}

}
