<?php

namespace Elementor;

class Grogin_Product_Categories_Widget extends Widget_Base {
    use Grogin_Helper;
	
    public function get_name() {
        return 'grogin-product-categories';
    }
    public function get_title() {
        return 'Product Categories (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'categories_type',
			[
				'label' => esc_html__( 'Categories Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'type1'	  => esc_html__( 'Type 1', 'grogin-core' ),
					'type2'	  => esc_html__( 'Type 2', 'grogin-core' ),
					'type3'	  => esc_html__( 'Type 3', 'grogin-core' ),
				],
			]
		);
		
		$this->start_controls_tabs('cat_exclude_include_tabs');
        $this->start_controls_tab('cat_include_tab',
            [ 'label' => esc_html__( 'Include Category', 'grogin-core' ) ]
        );
       
        $this->add_control( 'cat_filter',
            [
                'label' => esc_html__( 'Include Category', 'grogin-core' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'default' => '',
                'label_block' => true,
            ]
        );
		
		$this->end_controls_tab(); // cat_include_tab 
		
        $this->start_controls_tab( 'cat_exclude_tab',
            [ 'label' => esc_html__( 'Exclude Category', 'grogin-core' ) ]
        );
		
        $this->add_control( 'exclude_category',
            [
                'label' => esc_html__( 'Exclude Category', 'grogin-core' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'default' => '',
                'label_block' => true,
            ]
        );
       
		$this->end_controls_tab(); // cat_exclude_tab

		$this->end_controls_tabs(); // cat_exclude_include_tabs
		
		$this->add_control( 'column',
			[
				'label' => esc_html__( 'Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '9',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
					'7'		  => esc_html__( '7 Columns', 'grogin-core' ),
					'8'		  => esc_html__( '8 Columns', 'grogin-core' ),
					'9'		  => esc_html__( '9 Columns', 'grogin-core' ),
					'10'	  => esc_html__( '10 Columns', 'grogin-core' ),
					'11'	  => esc_html__( '11 Columns', 'grogin-core' ),
				],
			]
		);

		$this->add_control( 'tablet_column',
			[
				'label' => esc_html__( 'Tablet Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'2' 	  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
					'7'		  => esc_html__( '7 Columns', 'grogin-core' ),
					'8'		  => esc_html__( '8 Columns', 'grogin-core' ),
					'9'		  => esc_html__( '9 Columns', 'grogin-core' ),
				],
			]
		);

		$this->add_control( 'mobile_column',
			[
				'label' => esc_html__( 'Mobile Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'2' 	  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
					'7'		  => esc_html__( '7 Columns', 'grogin-core' ),
				],
			]
		);

		$this->add_control( 'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);
		
        $this->add_control( 'auto_speed',
            [
                'label' => esc_html__( 'Auto Speed', 'chakta' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '1600',
                'pleaceholder' => esc_html__( 'Set auto speed.', 'chakta' ),
				'condition' => ['auto_play' => 'true']
            ]
        );
		
		$this->add_control( 'dots',
			[
				'label' => esc_html__( 'Dots', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'false',
			]
		);
		
		$this->add_control( 'arrows',
			[
				'label' => esc_html__( 'Arrows', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

        $this->add_control( 'slide_speed',
            [
                'label' => esc_html__( 'Slide Speed', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '600',
                'pleaceholder' => esc_html__( 'Set slide speed.', 'grogin-core' ),
            ]
        );
		
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'grogin-core' ),
                    'DESC' => esc_html__( 'Descending', 'grogin-core' )
                ],
                'default' => 'ASC'
            ]
        );
		
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'grogin-core' ),
                    'menu_order' => esc_html__( 'Menu Order', 'grogin-core' ),
                    'rand' => esc_html__( 'Random', 'grogin-core' ),
                    'date' => esc_html__( 'Date', 'grogin-core' ),
                    'title' => esc_html__( 'Title', 'grogin-core' ),
                ],
                'default' => 'menu_order',
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if($settings['cat_filter'] || $settings['exclude_category']){
			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => 1,
				'parent'    => 0,
				'include'   => $settings['cat_filter'],
				'exclude'   => $settings['exclude_category'],
				'order'          => $settings['order'],
				'orderby'        => $settings['orderby']
			) );
		} else {
			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => 1,
				'parent'    => 0,
				'order'          => $settings['order'],
				'orderby'        => $settings['orderby']
			) );
		}
		
		$categorytype= '';
		$categorybordertype= '';

		if($settings['categories_type'] == 'type3'){
			$categorytype .= 'style-3';
			$categorybordertype .= '';
		} elseif($settings['categories_type'] == 'type2'){	
			$categorytype .= 'style-2';
			$categorybordertype .= '';
		} else {
			$categorytype .= 'style-1';
			$categorybordertype .= 'border';
		}	
			
		echo '<div class="site-module">';
		echo '<div class="site-module-body">';
		echo '<div class="site-slider carousel-style slider-loading-height loader-default arrows-filled filled-white arrows-scale '.esc_attr($categorybordertype).' " data-speed="'.esc_attr($settings['slide_speed']).'" data-items="'.esc_attr($settings['column']).'" data-itemsTablet="'.esc_attr($settings['tablet_column']).'" data-itemsMobile="'.esc_attr($settings['mobile_column']).'" data-itemScroll="1" data-arrows="'.esc_attr($settings['arrows']).'" data-dots="'.esc_attr($settings['dots']).'" data-infinite="true" data-draggable="true" data-autoplay="'.esc_attr($settings['auto_play']).'" data-autospeed="'.esc_attr($settings['auto_speed']).'">';
	  
		foreach ( $terms as $term ) {
			$term_data = get_option('taxonomy_'.$term->term_id);
			$thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
			$image = wp_get_attachment_url( $thumbnail_id );
			$term_children = get_term_children( $term->term_id, 'product_cat' );
			
			echo '<div class="slider-item">';
			echo '<div class="store-category-box '.esc_attr($categorytype).'">';
			echo '<div class="category-thumbnail">';
			if($image){
				echo '<a href="'.esc_url(get_term_link( $term )).'"><img src="'.esc_url($image).'" alt="'.esc_attr($term->name).'"></a>';
			}
			echo '</div><!-- category-thumbnail -->';
			echo '<div class="category-detail">';
			echo '<h3 class="entry-title"><a href="'.esc_url(get_term_link( $term )).'">'.esc_html($term->name).'</a></h3>';
			echo '</div><!-- category-detail -->';
			echo '</div><!-- store-category-box -->';
			echo '</div><!-- slider-item -->';
			
		}

		echo '</div><!-- site-slider -->';
		echo '</div><!-- site-module-body -->';
		echo '</div><!-- site-module -->';
	}

}
