<?php

namespace Elementor;

class Grogin_Product_Grid_Widget extends Widget_Base {
    use Grogin_Helper;

    public function get_name() {
        return 'grogin-product-grid';
    }
    public function get_title() {
        return 'Product Grid (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'grid_type',
			[
				'label' => esc_html__( 'Product Grid Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' 	=> esc_html__( 'Select Type', 'grogin-core' ),
					'type1' 		=> esc_html__( 'Type 1', 'grogin-core' ),
					'type2'			=> esc_html__( 'Type 2', 'grogin-core' ),
				],
			]
		);

		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/***** START QUERY CONTROLS SECTION *****/
		$this->grogin_query_elementor_controls($post_count = 6, $column = 3);
		/***** END QUERY CONTROLS SECTION *****/
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$output = '';
		
		if($settings['grid_type'] == 'type2'){
			$output .= '<div class="site-module products-grid-module style-4">';
			$output .= '<div class="site-module-body">';
			$output .= '<div class="module-row position-relative border-block products-separate-top product-extra-padding">';
			$output .= '<div class="products md-list-style column-'.esc_attr($settings['mobile_column']).' sm-column-'.esc_attr($settings['tablet_column']).' lg-column-'.esc_attr($settings['column']).'">';
            $output .= $this->grogin_elementor_product_loop($settings);                 
			$output .= '</div><!-- products -->';
			$output .= '</div><!-- module-row -->';
			$output .= '</div>';
			$output .= '</div>';
			
			echo $output;
		} else {
			$output .= '<div class="site-module products-grid-module style-1">';
			$output .= '<div class="site-module-body border-block">';
			$output .= '<div class="products md-list-style column-'.esc_attr($settings['mobile_column']).' sm-column-'.esc_attr($settings['tablet_column']).' lg-column-'.esc_attr($settings['column']).'">';
			$output .= $this->grogin_elementor_product_loop($settings);            
			$output .= '</div><!-- products -->';
			$output .= '</div><!-- site-module-body -->';	
			$output .= '</div><!-- site-module -->'; 
			
			echo $output;
		}	
	}

}
