<?php

namespace Elementor;

class Grogin_Special_Product_Widget extends Widget_Base {
    use Grogin_Helper;

    public function get_name() {
        return 'grogin-special-product';
    }
    public function get_title() {
        return 'Special Product (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'special_type',
			[
				'label' => esc_html__( 'Special Type', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type1',
				'options' => [
					'select-type' => esc_html__( 'Select Type', 'grogin-core' ),
					'type1'	  => esc_html__( 'Type 1', 'grogin-core' ),
					'type2'	  => esc_html__( 'Type 2', 'grogin-core' ),
				],
			]
		);
	
        // Posts Per Page
        $this->add_control( 'post_count',
            [
                'label' => esc_html__( 'Posts Per Page', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => count( get_posts( array('post_type' => 'product', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default' => 1
            ]
        );
		
        $this->add_control( 'cat_filter',
            [
                'label' => esc_html__( 'Filter Category', 'grogin-core' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'default' => '',
                'label_block' => true,
            ]
        );
		
        $this->add_control( 'post_include_filter',
            [
                'label' => esc_html__( 'Include Post', 'grogin-core' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Include',
                'label_block' => true,
            ]
        );
		
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'grogin-core' ),
                    'DESC' => esc_html__( 'Descending', 'grogin-core' )
                ],
                'default' => 'DESC'
            ]
        );
		
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'grogin-core' ),
                    'menu_order' => esc_html__( 'Menu Order', 'grogin-core' ),
                    'rand' => esc_html__( 'Random', 'grogin-core' ),
                    'date' => esc_html__( 'Date', 'grogin-core' ),
                    'title' => esc_html__( 'Title', 'grogin-core' ),
                ],
                'default' => 'date',
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$output = '';
		
		
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
	
		$args = array(
			'post_type' => 'product',
			'posts_per_page' => $settings['post_count'],
			'order'          => 'DESC',
			'post_status'    => 'publish',
			'paged' 			=> $paged,
            'post__in'       => $settings['post_include_filter'],
            'order'          => $settings['order'],
			'orderby'        => $settings['orderby']
		);
	
		if($settings['cat_filter']){
			$args['tax_query'][] = array(
				'taxonomy' 	=> 'product_cat',
				'field' 	=> 'term_id',
				'terms' 	=> $settings['cat_filter']
			);
		}
		
		$specialtype= '';

		if($settings['special_type'] == 'type2'){
			$specialtype .= 'style-2';
		} else {
			$specialtype .= 'style-1';
		}
				
		$output .= '<div class="klb-special site-featured-product '.esc_attr($specialtype).'">';
		
		$loop = new \WP_Query( $args );
		if ( $loop->have_posts() ) {
			while ( $loop->have_posts() ) : $loop->the_post();
				global $product;
				global $post;
				global $woocommerce;
			
				$id = get_the_ID();
				$allproduct = wc_get_product( get_the_ID() );

				$cart_url = wc_get_cart_url();
				$price = $allproduct->get_price_html();
				$weight = $product->get_weight();
				$stock_status = $product->get_stock_status();
				$stock_text = $product->get_availability();
				$short_desc = $product->get_short_description();
				$rating = wc_get_rating_html($product->get_average_rating());
				$ratingcount = $product->get_review_count();
				$wishlist = get_theme_mod( 'grogin_wishlist_button', '0' );
				$compare = get_theme_mod( 'grogin_compare_button', '0' );
				$quickview = get_theme_mod( 'grogin_quick_view_button', '0' );
				
				if( $product->is_type('variable') ) {
					$variation_ids = $product->get_visible_children();

					if($variation_ids[0]){
						$variation = wc_get_product( $variation_ids[0] );
				
						$sale_price_dates_to = ( $date = get_post_meta( $variation_ids[0], '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
					} else {
						$sale_price_dates_to = '';
					}
				} else {
					$sale_price_dates_to = ( $date = get_post_meta( $id, '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
				}

				$managestock = $product->managing_stock();
				$stock_quantity = $product->get_stock_quantity();
				$stock_format = esc_html__('Only %s left in stock','grogin-core');
				$stock_poor = '';
				if($managestock && $stock_quantity < 10) {
					$stock_poor .= '<div class="product-message color-danger">'.sprintf($stock_format, $stock_quantity).'</div>';
				}
				
				$total_sales = $product->get_total_sales();
				$total_stock = $total_sales + $stock_quantity;
				
				if($managestock) {
				$progress_percentage = floor($total_sales / (($total_sales + $stock_quantity) / 100)); // yuvarlama
				}

				$postview  = isset( $_POST['shop_view'] ) ? $_POST['shop_view'] : '';
				
				$output .= '<div class="'.esc_attr( implode( ' ', wc_get_product_class( '', $product->get_id()))).'">';
				$output .= '<div class="product-wrapper">';
				$output .= '<div class="product-inner">';
				$output .= '<div class="thumbnail-wrapper">';
					
				$output .= grogin_sale_percentage();
					
				$output .= '<div class="thumbnail-buttons">';
					ob_start();
					do_action('grogin_wishlist_action');
					$output .= ob_get_clean();
					
					$output .= grogin_quickview();
				$output .= '</div><!-- thumbnail-buttons -->';
				$output .= ' <div class="product-thumbnail entry-media">';
					ob_start();
					$output .= grogin_product_second_image();
					$output .= ob_get_clean();
					
				$output .= '</div>';
				$output .= '</div><!-- thumbnail-wrapper -->';
				$output .= '<div class="content-wrapper">';
				$output .= '<div class="product-heading">';
				
				if($ratingcount){
					$output .= '<div class="product-rating">';
					$output .= $rating;
					$output .= '<div class="rating-count">';
					$output .= '<span class="count-text">'.esc_html($ratingcount).'</span>';
					$output .= '</div><!-- rating-count -->';
					$output .= '</div><!-- product-rating -->';  
				} 
				
				$output .= '<h2 class="product-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h2>';
				$output .= '</div><!-- product-heading -->';
				$output .= '<div class="product-price-wrapper d-flex flex-column align-items-start gap-1">';
				$output .= '<span class="price">';
				$output .= $price;
				$output .= '</span><!-- price -->';                    
				$output .= '</div><!-- product-price-wrapper -->';
				
				if($short_desc){
					$output .= '<div class="product-excerpt entry-excerpt">';
					
					$output .= '<p>' .$short_desc. '</p>';					
					$output .= '</div><!-- product-excerpt -->';
				}
				
				if($managestock && $stock_quantity > 0) {
					$output .= '<div class="product-progress">';
					$output .= '<span class="d-block text-11 text-gray-400 mb-8">'.esc_html__('This product is about to run out', 'grogin-core').'</span>';
					$output .= '<div class="site-progress-bar"><span style="width: '.$progress_percentage.'%;"></span></div>';
					$output .= '<div class="product-progress-detail">';
					$output .= '<p>'.esc_html__('available only:','grogin-core').'</p> <span>'.esc_html($stock_quantity).'</span>';
					$output .= '</div><!-- product-progress-detail -->';
					$output .= '</div><!-- product-progress -->';
				}
				
				$output .= '<div class="product-cart cart-with-quantity d-flex flex-wrap align-items-center mt-14">';
					ob_start();
					woocommerce_template_loop_add_to_cart();
					$output .= ob_get_clean();;
				$output .= '</div><!-- product-cart -->';
				$output .= '</div><!-- content-wrapper -->';
				$output .= '</div><!-- product-inner -->';
				$output .= '</div><!-- product-wrapper -->';
				$output .= '</div><!-- product -->';
				
			endwhile;
		}
		wp_reset_postdata();
		
		$output .= '</div><!-- site-featured-product -->';
		
		echo $output;
	}

}
