<?php

namespace Elementor;

class Grogin_Vendor_Grid_Widget extends Widget_Base {

    public function get_name() {
        return 'grogin-vendor-grid';
    }
    public function get_title() {
        return 'Vendor Grid (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Popular Companies',
                'description'=> 'Add a title.',
				'label_block' => true,
            ]
        );
		
		$this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'grogin-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Some of the new products arriving this weeks',
                'description'=> 'Add a description.',
				'label_block' => true,
            ]
        );
		
        $this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View All',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' ),
            ]
        );
		
        $this->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' ),
            ]
        );
		
		$this->add_control( 'vendor_count',
			[
				'label' => esc_html__( 'Vendors Per Page', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'1' 	  => esc_html__( '1 Columns', 'grogin-core' ),
					'2' 	  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'column',
			[
				'label' => esc_html__( 'Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'1' 	  => esc_html__( '1 Columns', 'grogin-core' ),
					'2' 	  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'mobile_column',
			[
				'label' => esc_html__( 'Mobile Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'1' 	  => esc_html__( '1 Column', 'grogin-core' ),
					'2'		  => esc_html__( '2 Columns', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'tablet_column',
			[
				'label' => esc_html__( 'Tablet Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'1' 	  => esc_html__( '1 Column', 'grogin-core' ),
					'2'		  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
				],
			]
		);
		
		/*****   END CONTROLS SECTION   ******/
		$this->end_controls_section();
		
		/*****   START CONTROLS SECTION   ******/
		$this->start_controls_section('blonwe_styling',
            [
                'label' => esc_html__( ' Style', 'blonwe' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_control( 'title_heading',
            [
                'label' => esc_html__( 'TITLE', 'blonwe-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_responsive_control( 'title_size',
            [
                'label' => esc_html__( 'Title Size', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header .entry-title' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'title_weight',
            [
                'label' => esc_html__( 'Title Weight', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header .entry-title' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'title_color',
			[
               'label' => esc_html__( 'Title Color', 'blonwe-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header .entry-title' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_control( 'title_hvrcolor',
			[
               'label' => esc_html__( 'Title Hover Color', 'blonwe-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}}  .site-module-header .entry-title:hover' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_control( 'title_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .site-module-header .entry-title ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .site-module-header .entry-title',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__( 'Typography', 'blonwe-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .site-module-header .entry-title',
				
            ]
        );
		
		$this->add_control( 'subtitle_heading',
            [
                'label' => esc_html__( 'SUBTITLE', 'blonwe-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before',
            ]
        );
		
		$this->add_responsive_control( 'subtitle_size',
            [
                'label' => esc_html__( 'Subtitle Size', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header p ' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'subtitle_weight',
            [
                'label' => esc_html__( 'Subtitle Weight', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header p ' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'subtitle_color',
			[
               'label' => esc_html__( 'Subtitle Color', 'blonwe-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header p' => 'color: {{VALUE}} !important;'],
			]
        );
		
		$this->add_control( 'subtitle_hvrcolor',
			[
               'label' => esc_html__( 'Subtitle Hover Color', 'blonwe-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header p:hover' => 'color: {{VALUE}} !important;'],
			]
        );
		
		$this->add_control( 'subtitle_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'blonwe-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .site-module-header p ' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle_text_shadow',
				'selector' => '{{WRAPPER}} .site-module-header p ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__( 'Typography', 'blonwe-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .site-module-header p',
				
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('btn_styling',
            [
                'label' => esc_html__( ' Button Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} a.btn  '
            ]
        );
		
		$this->add_control( 'btn_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_control( 'btn_color',
            [
                'label' => esc_html__( 'Color', 'grogin-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'color: {{VALUE}};']
            ]
        );
		
		$this->add_responsive_control( 'btn_icon_size',
            [
                'label' => esc_html__( 'Button Icon Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} a.btn i' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
	    $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => esc_html__( 'Border', 'grogin-core' ),
                'selector' => '{{WRAPPER}} a.btn ',
            ]
        );
        
		$this->add_responsive_control( 'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],
            ]
        );
		
		$this->add_responsive_control( 'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],              
            ]
        );
       
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'label' => esc_html__( 'Background', 'grogin-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} a.btn',
            ]
        );
		
		$this->add_responsive_control( 'btn_height',
            [
                'label' => esc_html__( 'Button Height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} a.btn' => 'height: {{SIZE}}px !important;' ],
            ]
        );
		
		/*****   END CONTROLS SECTION   ******/
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$target = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
		
		echo '<div class="site-module">';
		echo '<div class="site-module-header d-flex flex-wrap align-items-center justify-content-between mb-10 md-mb-20">';
		echo '<div class="col d-inline-flex flex-wrap align-items-center gap-0-5 gap-md-3">';
		
		if($settings['title']){
			echo '<h3 class="entry-title text-16 md-text-18 fw-bold mb-0">'.esc_html($settings['title']).'</h3>';
		}
		
		if($settings['desc']){
			echo '<p class="text-13 text-gray-400 mb-0">'.esc_html($settings['desc']).'</p>';
		}
		
		echo '</div><!-- col -->';
		
		if($settings['btn_title']){
			echo '<div class="col flex-auto">';
			echo '<a href="'.esc_url($settings['btn_link']['url']).'" '.esc_attr($target.$nofollow).' class="btn btn-white xs rounded icon-right btn-more">';
			echo '<span>'.esc_html($settings['btn_title']).' <i class="klb-icon-move-right"></i></span> <i class="klb-icon-more-horizontal"></i>';
			echo '</a>';
			echo '</div><!-- col -->';
		}
		
		echo '</div><!-- site-module-header -->';
		echo '<div class="site-module-body site-store-boxes border-block column-'.esc_attr($settings['mobile_column']).' sm-column-'.esc_attr($settings['tablet_column']).' lg-column-'.esc_attr($settings['column']).' ">';
        
		$seller_args = [
            'number' => $settings['vendor_count'],

        ];
		
		$sellers = dokan_get_sellers($seller_args);
		 
	    foreach ($sellers['users'] as $seller){			
			
			$vendor                   = dokan()->vendor->get( $seller->ID );	
			$user_description 		  = get_the_author_meta( 'description', $seller->ID );
			$store_banner_id          = $vendor->get_banner_id();
			$store_name               = $vendor->get_shop_name();
			$store_url                = $vendor->get_shop_url();
			$store_rating             = $vendor->get_rating();
			$is_store_featured        = $vendor->is_featured();
			$store_phone              = $vendor->get_phone();
			$store_info               = dokan_get_store_info( $seller->ID );
			$store_address            = dokan_get_seller_short_address( $seller->ID );
			$store_banner_url         = $store_banner_id ? wp_get_attachment_image_src( $store_banner_id, $image_size ) : '';
			$show_store_open_close    = dokan_get_option( 'store_open_close', 'dokan_appearance', 'on' );
			$dokan_store_time_enabled = isset( $store_info['dokan_store_time_enabled'] ) ? $store_info['dokan_store_time_enabled'] : '';
			$store_open_is_on         = ( 'on' === $show_store_open_close && 'yes' === $dokan_store_time_enabled && ! $is_store_featured ) ? 'store_open_is_on' : '';
			
			
			echo '<div class="column">';
			echo '<div class="site-store-box">';
			echo '<div class="store-box-header d-flex flex-wrap align-items-center">';
			echo '<div class="store-brand">';
			echo '<a href="'.esc_url($store_url ).'">';
			echo '<img src="'.esc_url( $vendor->get_avatar() ).'" />';
			echo '</a>';
			echo '</div><!-- store-brand -->';
			echo '<div class="store-detail">';
			echo '<h3 class="entry-title text-15 fw-bold mb-0"><a href="'.esc_url($store_url ).'">'.esc_html($store_name ).'</a></h3>';
			if ( $is_store_featured ){
				echo '<p class="text-12 text-gray-500 mb-0">'.esc_html__( 'Featured', 'grogin-core' ).'</p>';
			}
			echo '<div class="product-rating">';
			echo wc_get_rating_html($store_rating['rating'], $store_rating['count'] );
			echo '<div class="rating-count">';
			echo  '<span class="count-text">'.esc_html($store_rating['count']).'</span>';
			echo '</div><!-- rating-count -->';
			echo '</div><!-- product-rating -->';   
			echo '</div><!-- store-detail -->';
			echo '</div><!-- store-box-header -->';
			if ( $user_description ){
				echo '<div class="store-box-footer">';
				echo '<ul>';
				echo '<li>'.esc_html($user_description ).' </li>';
				echo '</ul>';

				echo '</div><!-- store-box-footer -->';
			}
			echo '</div><!-- site-store-box -->';    
			echo '</div><!-- column -->';
			
		}
		
		echo '</div><!-- site-module-body -->';
		echo '</div><!-- site-module -->'; 
		
	}

}
