<?php 
/*************************************************
## Grogin Typography
*************************************************/

function grogin_rgba_selector($rgbacolor = ''){
	$explode = array_slice(explode(',',$rgbacolor), 0, -1);
	$implode = implode(',', $explode);

	return str_replace("rgba(", "",$implode);
}


function grogin_custom_styling() { ?>

<style type="text/css">

<?php if (get_theme_mod( 'grogin_mobile_sticky_header',0 ) == 1) { ?>
@media(max-width:64rem){
	header.site-header.sticky-header {
		position: relative;
		z-index: 99;
	}
	.sticky-header .header-main {
		position: fixed !important;
		width: 100%;
		top: 0;
		z-index: 10;
	}

	.sticky-header .header-main::before {
		content: "";
		position: absolute;
		width: 100%;
		height: 0.0625rem;
		bottom: 0;
		background-color: currentColor;
		opacity: 0.1;
	}

	.site-header.header-type5.sticky-header .header-main .site-brand .light-logo{
		opacity: 0 !important;
	}

	.site-header.sticky-header.header-type5 .header-main .site-brand .dark-logo{
		opacity: 1 !important;
	}

	.single-product-sticky.active {
		margin-top: 78px;
	}
}
<?php } ?>

<?php if (get_theme_mod( 'grogin_sticky_header',0 ) == 1) { ?>
@media(min-width:64rem){
	header.site-header.sticky-header {
		position: relative;
		z-index: 99;
	}
	.sticky-header .header-main {
		position: fixed !important;
		width: 100%;
		top: 0;
		z-index: 10;
	}

	.sticky-header .header-main::before {
		content: "";
		position: absolute;
		width: 100%;
		height: 0.0625rem;
		bottom: 0;
		background-color: currentColor;
		opacity: 0.1;
	}

	.site-header.header-type5.sticky-header .header-main .site-brand .light-logo{
		opacity: 0 !important;
	}

	.site-header.sticky-header.header-type5 .header-main .site-brand .dark-logo{
		opacity: 1 !important;
	}

	.single-product-sticky.active {
		margin-top: 78px;
	}
}
<?php } ?>

<?php if (get_theme_mod( 'grogin_mobile_single_sticky_cart',0 ) == 1) { ?>
@media(max-width:64rem){
	.single .product-type-simple form.cart {
	    position: fixed;
	    bottom: 0;
	    right: 0;
	    z-index: 999999;
	    background: #fff;
	    margin-bottom: 0;
	    padding: 15px;
	    -webkit-box-shadow: 0 -2px 5px rgb(0 0 0 / 7%);
	    box-shadow: 0 -2px 5px rgb(0 0 0 / 7%);
	    justify-content: space-between;
		width: 100%;
	}

	.single .woocommerce-variation-add-to-cart {
	    display: -webkit-box;
	    display: -ms-flexbox;
	    display: flex;
	    position: fixed;
	    bottom: 0;
	    right: 0;
	    z-index: 999999;
	    background: #fff;
	    margin-bottom: 0;
	    padding: 15px;
	    -webkit-box-shadow: 0 -2px 5px rgb(0 0 0 / 7%);
	    box-shadow: 0 -2px 5px rgb(0 0 0 / 7%);
	    justify-content: space-between;
    	width: 100%;
		flex-wrap: wrap;
		width: 100%; 
	}

	.single .site-footer .footer-row.footer-copyright {
	    margin-bottom: 79px;
	}

}
<?php } ?>

<?php if (get_theme_mod( 'grogin_main_color' )) { ?>
:root {
    --theme-primary-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
}
<?php } ?>

<?php if (get_theme_mod( 'grogin_main_active_color' )) { ?>
:root {
    --theme-primary-active-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_active_color' ) ); ?>;
}
<?php } ?>

<?php if (get_theme_mod( 'grogin_secondary_color' )) { ?>
:root {
    --theme-secondary-color: <?php echo esc_attr(get_theme_mod( 'grogin_secondary_color' ) ); ?>;
}
<?php } ?>

<?php if (get_theme_mod( 'grogin_secondary_active_color' )) { ?>
:root {
    --theme-secondary-active-color: <?php echo esc_attr(get_theme_mod( 'grogin_secondary_active_color' ) ); ?>;
}
<?php } ?>


<?php if(function_exists('dokan')){ ?>

	input[type='submit'].dokan-btn-theme,
	a.dokan-btn-theme,
	.dokan-btn-theme {
		background-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
		border-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	input[type='submit'].dokan-btn-theme .badge,
	a.dokan-btn-theme .badge,
	.dokan-btn-theme .badge {
		color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-announcement-uread {
		border: 1px solid <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?> !important;
	}
	.dokan-announcement-uread .dokan-annnouncement-date {
		background-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?> !important;
	}
	.dokan-announcement-bg-uread {
		background-color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-dashboard .dokan-dash-sidebar ul.dokan-dashboard-menu li:hover {
		background: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-dashboard .dokan-dash-sidebar ul.dokan-dashboard-menu li.dokan-common-links a:hover {
		background: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-dashboard .dokan-dash-sidebar ul.dokan-dashboard-menu li.active {
		background: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-product-listing .dokan-product-listing-area table.product-listing-table td.post-status label.pending {
		background: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.product-edit-container .dokan-product-title-alert,
	.product-edit-container .dokan-product-cat-alert {
		color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.product-edit-container .dokan-product-less-price-alert {
		color: <?php echo esc_attr(get_theme_mod( 'grogin_main_color' ) ); ?>;
	}
	.dokan-store-wrap {
	    margin-top: 3.5rem;
	}
	.dokan-widget-area ul {
	    list-style: none;
	    padding-left: 0;
	    font-size: .875rem;
	    font-weight: 400;
	}
	.dokan-widget-area ul li a {
	    text-decoration: none;
	    color: var(--color-text-lighter);
	    margin-bottom: .625rem;
	    display: inline-block;
	}
	form.dokan-store-products-ordeby:before, 
	form.dokan-store-products-ordeby:after {
		content: '';
		display: table;
		clear: both;
	}
	.dokan-store-products-filter-area .orderby-search {
	    width: auto;
	}
	input.search-store-products.dokan-btn-theme {
	    border-top-left-radius: 0;
	    border-bottom-left-radius: 0;
	}
	.dokan-pagination-container .dokan-pagination li a {
	    display: -webkit-inline-box;
	    display: -ms-inline-flexbox;
	    display: inline-flex;
	    -webkit-box-align: center;
	    -ms-flex-align: center;
	    align-items: center;
	    -webkit-box-pack: center;
	    -ms-flex-pack: center;
	    justify-content: center;
	    font-size: .875rem;
	    font-weight: 600;
	    width: 2.25rem;
	    height: 2.25rem;
	    border-radius: 50%;
	    color: currentColor;
	    text-decoration: none;
	    border: none;
	}
	.dokan-pagination-container .dokan-pagination li.active a {
	    color: #fff;
	    background-color: var(--color-secondary) !important;
	}
	.dokan-pagination-container .dokan-pagination li:last-child a, 
	.dokan-pagination-container .dokan-pagination li:first-child a {
	    width: auto;
	}

	.vendor-customer-registration label {
	    margin-right: 10px;
	}

	.woocommerce-mini-cart dl.variation {
	    display: none;
	}

	.product-name dl.variation {
	    display: none;
	}

	.seller-rating .star-rating span.width + span {
	    display: none;
	}
	
	.seller-rating .star-rating {width: 70px;display: block;}

<?php } ?>

<?php if (function_exists('get_wcmp_vendor_settings') && is_user_logged_in()) {
	if(is_vendor_dashboard()){	
} ?>

.woosc-popup, div#woosc-area {
    display: none;
}
	
.select-location {
    display: none;
}
	
<?php } ?>

.global-notification{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_top_notification_count_date_bg_color' ) ); ?>;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_top_notification_count_date_font_color' ) ); ?>;
}

:root {
    --theme-site-brand-height: <?php echo esc_attr(get_theme_mod( 'grogin_logo_size' ) ); ?>px;
}

:root {
    --theme-site-brand-mobile-height: <?php echo esc_attr(get_theme_mod( 'grogin_mobil_logo_size' ) ); ?>px;
}

.site-header.header-type1 .header-topbar{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_top_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_top_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_top_font_color' ) ); ?> !important;
}

.site-header.header-type1 .header-topbar a:hover{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_top_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type1 .header-topbar .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_top_submenu_font_color' ) ); ?> !important;
}

.site-header.header-type1 .header-main{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_main_bg_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_main_font_color' ) ); ?> !important;
}

.site-header.header-type1 .quick-button .action-link .action-icon{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_main_icon_color' ) ); ?>;
}

.site-header.header-type1 .header-nav {
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_border_color' ) ); ?> !important;
}

.site-header.header-type1 .header-nav .primary-menu > ul > li > a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_font_color' ) ); ?> !important;
}

.site-header.header-type1 .header-row .site-menu .menu>.menu-item.current-menu-item>a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type1 .header-row .site-menu .menu>.menu-item.current-menu-item>a::before{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type1 .header-nav .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type1 .header-nav .site-header .primary-menu > ul .sub-menu a:hover{
	text-decoration-color:  <?php echo esc_attr(get_theme_mod( 'grogin_header1_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type2 .header-topbar{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_top_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_top_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_top_font_color' ) ); ?> !important;
}

.site-header.header-type2 .header-topbar a:hover{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_top_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type2 .header-topbar .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_top_submenu_font_color' ) ); ?> !important;
}

.site-header.header-type2 .header-main{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_main_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_main_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_main_font_color' ) ); ?> !important;
}

.site-header.header-type2 .quick-button .action-link .action-icon{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_main_icon_color' ) ); ?>;
}

.site-header.header-type2 .header-nav {
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_border_color' ) ); ?> !important;
}

.site-header.header-type2 .header-nav .primary-menu > ul > li > a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_font_color' ) ); ?> !important;
}

.site-header.header-type2 .header-row .site-menu .menu>.menu-item.current-menu-item>a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type2 .header-row .site-menu .menu>.menu-item.current-menu-item>a::before{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type2 .header-nav .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type2 .header-nav .site-header .primary-menu > ul .sub-menu a:hover{
	text-decoration-color:  <?php echo esc_attr(get_theme_mod( 'grogin_header2_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type3 .header-topbar{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_top_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_top_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_top_font_color' ) ); ?> !important;
}

.site-header.header-type3 .header-topbar a:hover{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_top_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type3 .header-topbar .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_top_submenu_font_color' ) ); ?> !important;
}

.site-header.header-type3 .header-main{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_main_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_main_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_main_font_color' ) ); ?> !important;
}

.site-header.header-type3 .quick-button .action-link .action-icon{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_main_icon_color' ) ); ?>;
}

.site-header.header-type3 .header-nav {
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_border_color' ) ); ?> !important;
}

.site-header.header-type3 .header-nav .primary-menu > ul > li > a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_font_color' ) ); ?> !important;
}

.site-header.header-type3 .header-row .site-menu .menu>.menu-item.current-menu-item>a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type3 .header-row .site-menu .menu>.menu-item.current-menu-item>a::before{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type3 .header-nav .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type3 .header-nav .site-header .primary-menu > ul .sub-menu a:hover{
	text-decoration-color:  <?php echo esc_attr(get_theme_mod( 'grogin_header3_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type4 .header-topbar,
.site-header.header-type4 .header-row.header-row-primary-active[class*=text-gray-]{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_top_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_top_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_top_font_color' ) ); ?> !important;
}

.site-header.header-type4 .header-topbar a:hover{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_top_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type4 .header-topbar .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_top_submenu_font_color' ) ); ?> !important;
}

.site-header.header-type4 .header-main{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_main_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_main_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_main_font_color' ) ); ?> !important;
}

.site-header.header-type4 .quick-button .action-link .action-icon{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_main_icon_color' ) ); ?>;
}

.site-header.header-type4 .header-nav {
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_border_color' ) ); ?> !important;
}

.site-header.header-type4 .header-nav .primary-menu > ul > li > a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_font_color' ) ); ?> !important;
}

.site-header.header-type4 .header-row .site-menu .menu>.menu-item.current-menu-item>a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type4 .header-row .site-menu .menu>.menu-item.current-menu-item>a::before{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type4 .header-nav .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type4 .header-nav .site-header .primary-menu > ul .sub-menu a:hover{
	text-decoration-color:  <?php echo esc_attr(get_theme_mod( 'grogin_header4_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type5 .header-topbar,
.site-header.header-type5 .header-row.header-row-primary-active[class*=text-gray-]{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_top_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_top_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_top_font_color' ) ); ?> !important;
}

.site-header.header-type5 .header-topbar a:hover{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_top_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type5 .header-topbar .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_top_submenu_font_color' ) ); ?> !important;
}

.site-header.header-type5 .header-main{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_main_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_main_border_color' ) ); ?> !important;
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_main_font_color' ) ); ?> !important;
}

.site-header.header-type5 .quick-button .action-link .action-icon{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_main_icon_color' ) ); ?>;
}

.site-header.header-type5 .header-nav {
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_bg_color' ) ); ?> !important;
	border-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_border_color' ) ); ?> !important;
}

.site-header.header-type5 .header-nav .primary-menu > ul > li > a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_font_color' ) ); ?> !important;
}

.site-header.header-type5 .header-row .site-menu .menu>.menu-item.current-menu-item>a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type5 .header-row .site-menu .menu>.menu-item.current-menu-item>a::before{
	background-color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_font_hvrcolor' ) ); ?> !important;
}

.site-header.header-type5 .header-nav .site-menu.horizontal ul .sub-menu a{
	color: <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_submenu_font_color' ) ); ?> !important;	
}

.site-header.header-type5 .header-nav .site-header .primary-menu > ul .sub-menu a:hover{
	text-decoration-color:  <?php echo esc_attr(get_theme_mod( 'grogin_header5_bottom_submenu_font_color' ) ); ?> !important;	
}
:root {
<?php
	// Body Typography
    $bodyfont = get_theme_mod('grogin_body_typography', []); 
	
	if ( isset( $bodyfont['font-family'] ) ) {
		echo '--theme-body-font: '.$bodyfont['font-family'].';'; 
	}
	
	if ( isset( $bodyfont['font-size'] ) ) {
		echo '--theme-body-font-size: '.$bodyfont['font-size'].';'; 
	}
	
	if ( isset( $bodyfont['variant'] ) ) {
		echo '--theme-body-font-weight: '.$bodyfont['variant'].';'; 
	}
	
	if ( isset( $bodyfont['letter-spacing'] ) ) {
		echo '--theme-body-letter-spacing: '.$bodyfont['letter-spacing'].';'; 
	}
	
	if ( isset( $bodyfont['line-height'] ) ) {
		echo '--theme-body-line-height: '.$bodyfont['line-height'].';'; 
	}
	
	if ( isset( $bodyfont['color'] ) ) {
		echo '--theme-body-color: '.$bodyfont['color'].';'; 
	}
	
	if ( get_theme_mod('grogin_body_background_typography') ) {
		echo '--theme-body-background: '.get_theme_mod('grogin_body_background_typography').';'; 
	}
	
	// Heading Typography
    $headingfont = get_theme_mod('grogin_heading_typography', []); 
	
	if ( isset( $headingfont['font-family'] ) ) {
		echo '--theme-heading-font: '.$headingfont['font-family'].';'; 
	}
	
	if ( isset( $headingfont['variant'] ) ) {
		echo '--theme-heading-font-weight: '.$headingfont['variant'].';'; 
	}
	
	if ( isset( $headingfont['letter-spacing'] ) ) {
		echo '--theme-heading-letter-spacing: '.$headingfont['letter-spacing'].';'; 
	}
	
	// Main Menu Typography
    $menufont = get_theme_mod('grogin_menu_typography', []); 
	
	if ( isset( $menufont['font-family'] ) ) {
		echo '--theme-main-menu-font: '.$menufont['font-family'].';'; 
	}
	
	if ( isset( $menufont['font-size'] ) ) {
		echo '--theme-main-menu-font-size: '.$menufont['font-size'].';'; 
	}
	
	if ( isset( $menufont['variant'] ) ) {
		echo '--theme-main-menu-font-weight: '.$menufont['variant'].';'; 
	}
	
	if ( isset( $headingfont['letter-spacing'] ) ) {
		echo '--theme-main-menu-letter-spacing: '.$headingfont['letter-spacing'].';'; 
	}
	
	// Form Typography
    $formfont = get_theme_mod('grogin_form_typography', []); 
	
	if ( isset( $formfont['font-family'] ) ) {
		echo '--theme-form-input-font: '.$formfont['font-family'].';'; 
	}
	
	if ( isset( $formfont['variant'] ) ) {
		echo '--theme-form-input-font-weight: '.$formfont['variant'].';'; 
	}
	
	if ( isset( $formfont['font-size'] ) ) {
		echo '--theme-form-input-font-size: '.$formfont['font-size'].';'; 
	}
	
	if ( isset( $formfont['letter-spacing'] ) ) {
		echo '--theme-form-input-letter-spacing: '.$formfont['letter-spacing'].';'; 
	}
	
	if ( get_theme_mod('grogin_form_input_height') ) {
		echo '--theme-form-input-height: '.get_theme_mod('grogin_form_input_height').';'; 
	}

	// Button Typography
    $buttonfont = get_theme_mod('grogin_button_typography', []); 
	
	if ( isset( $buttonfont['font-family'] ) ) {
		echo '--theme-form-button-font: '.$buttonfont['font-family'].';'; 
	}
	
	if ( isset( $buttonfont['variant'] ) ) {
		echo '--theme-form-button-font-weight: '.$buttonfont['variant'].';'; 
	}
	
	if ( isset( $buttonfont['font-size'] ) ) {
		echo '--theme-form-button-font-size: '.$buttonfont['font-size'].';'; 
	}
	
	if ( isset( $buttonfont['letter-spacing'] ) ) {
		echo '--theme-form-button-letter-spacing: '.$buttonfont['letter-spacing'].';'; 
	}
	
	if ( get_theme_mod('grogin_button_height') ) {
		echo '--theme-form-button-height: '.get_theme_mod('grogin_button_height').';'; 
	}
	
	// Price Typography
    $pricefont = get_theme_mod('grogin_price_typography', []); 
	
	if ( isset( $pricefont['font-family'] ) ) {
		echo '--theme-product-price-font: '.$pricefont['font-family'].';'; 
	}
	
	if ( isset( $pricefont['variant'] ) ) {
		echo '--theme-product-price-font-weight: '.$pricefont['variant'].';'; 
	}
	
	if ( isset( $pricefont['font-size'] ) ) {
		echo '--theme-product-price-font-size: '.$pricefont['font-size'].';'; 
	}
	
	if ( isset( $buttonfont['letter-spacing'] ) ) {
		echo '--theme-product-price-letter-spacing: '.$buttonfont['letter-spacing'].';'; 
	}
	
	
	// Product Name Typography
    $productnamefont = get_theme_mod('grogin_product_name_typography', []); 
	
	if ( isset( $productnamefont['font-family'] ) ) {
		echo '--theme-product-title-font: '.$productnamefont['font-family'].';'; 
	}
	
	if ( isset( $productnamefont['variant'] ) ) {
		echo '--theme-product-title-font-weight: '.$productnamefont['variant'].';'; 
	}
	
	if ( isset( $productnamefont['font-size'] ) ) {
		echo '--theme-product-title-font-size: '.$productnamefont['font-size'].';'; 
	}
	
	if ( isset( $buttonfont['letter-spacing'] ) ) {
		echo '--theme-product-title-letter-spacing: '.$buttonfont['letter-spacing'].';'; 
	}

	
	// Border Radius
	if ( get_theme_mod('grogin_border_radius') ) {
		echo '--theme-site-border-radius: '.get_theme_mod('grogin_border_radius').';'; 
	}
	
	if ( get_theme_mod('grogin_site_width') ) {
		echo '--theme-site-width: '.get_theme_mod('grogin_site_width').';'; 
	}
	
	if ( get_theme_mod('grogin_site_gutter') ) {
		echo '--theme-site-gutter: '.get_theme_mod('grogin_site_gutter').';'; 
	}
	
	if ( get_theme_mod('grogin_excerpt_font_size') ) {
		echo '--theme-text-excerpt-font-size: '.get_theme_mod('grogin_excerpt_font_size').';'; 
	}
	
	if ( get_theme_mod('grogin_description_font_size') ) {
		echo '--theme-text-description-font-size: '.get_theme_mod('grogin_description_font_size').';'; 
	}
	
	if ( get_theme_mod('grogin_teaser_font_size') ) {
		echo '--theme-text-teaser-font-size: '.get_theme_mod('grogin_teaser_font_size').';'; 
	}
?>
}

</style>
<?php }
add_action('wp_head','grogin_custom_styling');

?>