<?php

/*************************************************
## Styles and Scripts
*************************************************/ 
define('KLB_INDEX_JS', plugin_dir_url( __FILE__ )  . '/js');
define('KLB_INDEX_CSS', plugin_dir_url( __FILE__ )  . '/css');

function klb_scripts() {
	wp_register_script( 'jquery-socialshare',    KLB_INDEX_JS . '/jquery-socialshare.js', array('jquery'), '1.0', true);
	wp_register_script( 'klb-social-share', 	 KLB_INDEX_JS . '/custom/social_share.js', array('jquery'), '1.0', true);
	wp_register_script( 'klb-gdpr', 	  		 KLB_INDEX_JS . '/custom/gdpr.js', array('jquery'), '1.0', true);

	if (function_exists('get_wcmp_vendor_settings') && is_user_logged_in()) {
		if(is_vendor_dashboard()){
			wp_deregister_script( 'bootstrap');
			wp_deregister_script( 'jquery-nice-select');
		}
	}
}
add_action( 'wp_enqueue_scripts', 'klb_scripts' );

/*----------------------------
  Elementor Get Templates
 ----------------------------*/
if ( ! function_exists( 'grogin_get_elementorTemplates' ) ) {
    function grogin_get_elementorTemplates( $type = null )
    {
        if ( class_exists( '\Elementor\Plugin' ) ) {

            $args = [
                'post_type' => 'elementor_library',
                'posts_per_page' => -1,
            ];

            $templates = get_posts( $args );
            $options = array();

            if ( !empty( $templates ) && !is_wp_error( $templates ) ) {

				$options['0'] = esc_html__('Set a Template','grogin-core');

                foreach ( $templates as $post ) {
                    $options[ $post->ID ] = $post->post_title;
                }
            } else {
                $options = array(
                    '' => esc_html__( 'No template exist.', 'grogin-core' )
                );
            }

            return $options;
        }
    }
}

/*----------------------------
  Single Share
 ----------------------------*/
add_action( 'grogin_single_social_share', 'grogin_social_share',40);
function grogin_social_share(){
	$socialshare = get_theme_mod( 'grogin_shop_social_share', '0' );

	if($socialshare == '1'){
		wp_enqueue_script('jquery-socialshare');
		wp_enqueue_script('klb-social-share');
	 
		$single_share_multicheck = get_theme_mod('grogin_shop_single_share',array( 'facebook', 'twitter', 'pinterest', 'linkedin'));
		
		echo'<div class="share-button">';
		echo'<a href="#"><i class="klb-icon-upload"></i></a> <span>'.esc_html__('Share this Product', 'grogin-core').'</span>';
		echo'<div class="share-buttons-holder">';
		echo'<div class="share-buttons-body">';
		echo'<div class="share-buttons-header">';
		echo'<h3 class="entry-title">'.esc_html__('Share this product', 'grogin-core').'</h3>';
		echo'<div class="site-button close-button">';
		echo'<a href="#"><i class="klb-icon-x"></i></a>';
		echo'</div><!-- site-button -->';                
		echo'</div><!-- share-buttons-header -->';
		echo'<div class="share-buttons-inner">';
		echo'<p class="text-12 text-gray-500">'.esc_html__('You can share the product with your friends', 'grogin-core').'</p>';
		echo'<div class="social-container site-social mb-20">';
			echo'<ul>';
				if(in_array('facebook', $single_share_multicheck)){
					echo'<li><a href="#" class="filled social-color facebook"><i class="klb-social-icon-facebook"></i></a></li>';
				}
				if(in_array('twitter', $single_share_multicheck)){
					echo'<li><a href="#" class="filled social-color twitter"><i class="klb-social-icon-twitter"></i></a></li>';
				}
				if(in_array('pinterest', $single_share_multicheck)){	
					echo'<li><a href="#" class="filled social-color pinterest"><i class="klb-social-icon-pinterest"></i></a></li>';
				}
				if(in_array('linkedin', $single_share_multicheck)){	
					echo'<li><a href="#" class="filled social-color linkedin"><i class="klb-social-icon-linkedin"></i></a></li>';
				}	
			echo'</ul>';
		echo'</div><!-- site-social -->';
		echo'<div class="copy-url">';
		echo'<p class="text-12 text-gray-500">'.esc_html__('Copy URL', 'grogin-core').'</p>';
		echo'<div class="site-url">';
		echo'<span class="url text-12">'.get_permalink().'</span>';
		echo'<span class="copy-text"><span class="copy">'.esc_html__('COPY', 'grogin-core').'</span><span class="copied d-none">'.esc_html__('COPIED', 'grogin-core').'</span></span>';
		echo'</div><!-- site-url -->';
		echo'</div><!-- copy-url -->';
		echo'</div><!-- share-buttons-inner -->';
		echo'</div><!-- share-buttons-body -->';
		echo'<div class="share-buttons-overlay"></div>';
		echo'</div><!-- share-buttons -->';
		echo'</div><!-- share-button -->';

	}
}

/*----------------------------
  Update Cart When Quantity changed on CART PAGE.
 ----------------------------*/
add_action( 'woocommerce_after_cart', 'grogin_update_cart' );
function grogin_update_cart() {
    echo '<script>
	
	var timeout;
	
    jQuery(document).ready(function($) {

		var timeout;

		$(\'.woocommerce\').on(\'change\', \'input.qty\', function(){

			if ( timeout !== undefined ) {
				clearTimeout( timeout );
			}

			timeout = setTimeout(function() {
				$("[name=\'update_cart\']").trigger("click");
			}, 1000 ); // 1 second delay, half a second (500) seems comfortable too

		});

    });
    </script>';
}

/*----------------------------
  Disable Crop Image WCMP
 ----------------------------*/
add_filter('wcmp_frontend_dash_upload_script_params', 'grogin_crop_function');
function grogin_crop_function( $image_script_params ) {
	$image_script_params['canSkipCrop'] = true;
	return $image_script_params;
}
