<?php
/*************************************************
* Mobile Filter
*************************************************/
add_action('wp_footer', 'grogin_mobile_filter'); 
function grogin_mobile_filter() { 

	$mobilebottommenu = get_theme_mod('grogin_mobile_bottom_menu','0');
	if($mobilebottommenu == '1'){

?>

	<?php $edittoggle = get_theme_mod('grogin_mobile_bottom_menu_edit_toggle','0'); ?>
	<?php if($edittoggle == '1'){ ?>
		<div class="klb-mobile-bottom site-mobile-navbar">
			<div class="mobile-navbar-inner">
				<nav class="site-menu horizontal mobile-nav">
					<ul>
						<?php $editrepeater = get_theme_mod('grogin_mobile_bottom_menu_edit'); ?>
						
						<?php foreach($editrepeater as $e){ ?>
							<?php if($e['mobile_menu_type'] == 'filter'){ ?>
								<?php if(is_shop()){ ?>
									<li>
										<a href="#" class="filter-button">
											<i class="klb-icon-<?php echo esc_attr($e['mobile_menu_icon']); ?>"></i>
											<span class="menu-text"><?php echo esc_html($e['mobile_menu_text']); ?></span>
										</a>
									</li>
								<?php } ?>
							<?php } elseif($e['mobile_menu_type'] == 'search'){ ?>
								<li>
									<div class="search-holder-button menu-drawer-toggle" data-drawer="site-search-drawer">
										<a href="#" class="search">
											<i class="klb-icon-<?php echo esc_attr($e['mobile_menu_icon']); ?>"></i>
											<span class="menu-text"><?php echo esc_html($e['mobile_menu_text']); ?></span>
										</a>
									</div>
								</li>
							<?php } elseif($e['mobile_menu_type'] == 'category'){ ?>
								<?php if(!is_shop()){ ?>
								<li>
									
									 <a href="#" class="menu-drawer-toggle" data-drawer="site-categories-drawer">
										<i class="klb-icon-<?php echo esc_attr($e['mobile_menu_icon']); ?>"></i>
										<span class="menu-text"><?php echo esc_html($e['mobile_menu_text']); ?></span>
									</a>
								</li>
								<?php } ?>
							<?php } else { ?>
								<li>
									<a href="<?php echo esc_url($e['mobile_menu_url']); ?>" class="user">
										<i class="klb-icon-<?php echo esc_attr($e['mobile_menu_icon']); ?>"></i>
										<span class="menu-text"><?php echo esc_html($e['mobile_menu_text']); ?></span>
									</a>
								</li>
							<?php } ?>
						<?php } ?>
					</ul>
				</nav>
			</div>
		</div>
	<?php } else { ?>
		<div class="klb-mobile-bottom site-mobile-navbar">
			<div class="mobile-navbar-inner">
				<nav class="site-menu horizontal mobile-nav">
					<ul>
						<li>
							<?php if(!is_shop()){ ?>
								<a href="<?php echo wc_get_page_permalink( 'shop' ); ?>" class="store">
									<i class="klb-icon-store"></i>
									<span class="menu-text"><?php esc_html_e('STORE','grogin-core'); ?></span>
								</a>
							<?php } else { ?>
								<a href="<?php echo esc_url( home_url( "/" ) ); ?>" class="store">
									<i class="klb-icon-home"></i>
									<span class="menu-text"><?php esc_html_e('HOME','grogin-core'); ?></span>
								</a>
							<?php } ?>
						</li>

						<?php if(is_shop()){ ?>
							<li>
								<a href="#" class="filter-button">
									<i class="klb-icon-filter"></i>
									<span class="menu-text"><?php esc_html_e('FILTER', 'grogin-core'); ?></span>
								</a>
							</li>
						<?php } ?>
						
						<li>
							<div class="search-holder-button menu-drawer-toggle" data-drawer="site-search-drawer">
								<a href="#" class="search">
									<i class="klb-icon-search"></i>
									<span class="menu-text"><?php esc_html_e('SEARCH','grogin-core'); ?></span>
								</a>
							</div>
						</li>
						
						<?php if ( class_exists( 'KlbWishlist' ) ) { ?>	
							<li>
								<a href="<?php echo KlbWishlist::get_url(); ?>" class="wishlist">
									<i class="klb-icon-heart-4"></i>
									<span class="menu-text"><?php esc_html_e('WISHLIST','grogin-core'); ?></span>
								</a>
							</li>
						<?php } ?>
						
						
						<li>
							<a href="<?php echo wc_get_page_permalink( 'myaccount' ); ?>" class="user">
								<i class="klb-icon-user-cut"></i>
								<span class="menu-text"><?php esc_html_e('ACCOUNT','grogin-core'); ?></span>
							</a>
						</li>

						<?php $sidebarmenu = get_theme_mod('grogin_header_sidebar','0'); ?>
						<?php if($sidebarmenu == '1'){ ?>
							<?php if(!is_shop()){ ?>
								<li>  
									 <a href="#" class="menu-drawer-toggle" data-drawer="site-categories-drawer">
										<i class="klb-icon-layout-list"></i>
										<span class="menu-text"><?php esc_html_e('CATEGORIES','grogin-core'); ?></span>
									</a>
								</li>
							<?php } ?>
						<?php } ?>

					</ul>
				</nav><!-- mobile-menu -->
			</div><!-- mobile-bottom-menu -->
		</div><!-- mobile-bottom-menu -->

	<?php } ?>
	
<?php }

    
}