<?php
/*************************************************
## Free shipping progress bar.
*************************************************/
function grogin_shipping_progress_bar() {
		
		$total           = WC()->cart->get_displayed_subtotal();
		$limit           = get_theme_mod( 'shipping_progress_bar_amount' );
		$percent         = 100;


		if ( $total < $limit ) {
			$percent = floor( ( $total / $limit ) * 100 );
			$message = str_replace( '[remainder]', wc_price( $limit - $total ), get_theme_mod( 'shipping_progress_bar_message_initial' ) );
			$class = 'warning';
		} else {
			$message = get_theme_mod( 'shipping_progress_bar_message_success' );
			$class = 'bg-green-50 border-green-200';
		}
		
	?>	
		<div class="klb-free-shipping woocommerce-notice site-free-shipping <?php echo esc_attr($class); ?>">
			<div class="notice-header shipping-notice-header text-green-800">
				<i class="klb-icon-box"></i>
				<p><?php echo wp_kses( $message, 'post' ); ?></p>
			</div><!-- shipping-notice -->
			<div class="shipping-progress">
				<span class="bg-green-600" style="width: <?php echo esc_attr( $percent ); ?>%"></span>
			</div><!-- shipping-progress -->
		</div>
			
	<?php
}

/*************************************************
## Free shipping progress bar.
*************************************************/
function grogin_shipping_cart_progress_bar() {
		
		$total           = WC()->cart->get_displayed_subtotal();
		$limit           = get_theme_mod( 'shipping_progress_bar_amount' );
		$percent         = 100;


		if ( $total < $limit ) {
			$percent = floor( ( $total / $limit ) * 100 );
			$message = str_replace( '[remainder]', wc_price( $limit - $total ), get_theme_mod( 'shipping_progress_bar_message_initial' ) );
			$class = 'warning';
		} else {
			$message = get_theme_mod( 'shipping_progress_bar_message_success' );
			$class = 'success';
		}
		
	?>	
		<div class="klb-cart-free-shipping mini-cart-notice text-center <?php echo esc_attr($class); ?>">
		  <p class="text-11"><?php echo wp_kses( $message, 'post' ); ?></p>
		  <div class="cart-notice-progress"><span style="width: <?php echo esc_attr( $percent ); ?>%;"></span></div>
		</div>
			
	<?php
}

if(get_theme_mod( 'shipping_progress_bar_location_card_page',0) == '1'){
	add_action( 'woocommerce_before_cart_table',  'grogin_shipping_progress_bar' );
}

if(get_theme_mod( 'shipping_progress_bar_location_mini_cart',0) == '1'){
	add_action( 'woocommerce_before_mini_cart', 'grogin_shipping_cart_progress_bar' );
}

if(get_theme_mod( 'shipping_progress_bar_location_checkout',0) == '1'){
	add_action( 'woocommerce_checkout_billing', 'grogin_shipping_progress_bar' );
}
