<?php if(grogin_page_settings('page_footer_type') == 'type2') { ?>
	 <?php $footertype = 'dark'; ?>
<?php } elseif( grogin_page_settings( 'page_footer_type' ) == 'type1') { ?>	
	<?php $footertype = 'gray'; ?>
<?php } elseif( get_theme_mod( 'grogin_footer_type' ) == 'type2') { ?>	
	<?php $footertype = 'dark'; ?>
<?php } else { ?>
	<?php $footertype = 'gray'; ?>
<?php } ?>
	
<footer class="site-footer position-relative z-2 <?php echo esc_attr($footertype); ?>">

	<?php $subscribe = get_theme_mod('grogin_footer_subscribe_area',0); ?>
	<?php if($subscribe == 1){ ?>
		<div class="footer-row footer-newsletter">
			<div class="container">
				<div class="footer-inner">
					<div class="column text-column d-inline-flex flex-column align-items-center align-items-md-start">
						<h3 class="entry-title text-18 md-text-20 fw-bold"><?php echo grogin_sanitize_data(get_theme_mod('grogin_footer_subscribe_title')); ?></h3>
						<div class="text-13 lh-base max-w-345 text-center text-sm-start">
							<p><?php echo grogin_sanitize_data(get_theme_mod('grogin_footer_subscribe_subtitle')); ?></p>
						</div><!-- entry-excerpt -->
					</div><!-- column -->
					<div class="column form-column d-inline-flex align-items-center justify-content-center justify-content-md-end">
						<div class="site-newsletter-form text-center text-sm-start">
							<?php echo do_shortcode('[mc4wp_form id="'.get_theme_mod('grogin_footer_subscribe_formid').'"]'); ?>
						</div><!-- site-newsletter-form -->
					</div><!-- column -->
				</div><!-- footer-inner -->
			</div><!-- container -->
		</div><!-- footer-row -->
    <?php } ?>
	
	<?php if ( is_active_sidebar( 'footer-1' ) || is_active_sidebar( 'footer-2' ) || is_active_sidebar( 'footer-3' ) || is_active_sidebar( 'footer-4' ) || is_active_sidebar( 'footer-4' )) { ?>
    <div class="footer-row footer-widgets">
        <div class="container">
			<div class="footer-inner">				 
				<?php if(get_theme_mod('grogin_footer_column') == '3columns'){ ?>
					<div class="column footer-widgets-block column-3">	
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-1' ); ?>
						</div><!-- col -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-2' ); ?>
						</div><!-- col -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-3' ); ?>
						</div><!-- col -->
					</div><!-- col -->
				<?php } elseif(get_theme_mod('grogin_footer_column') == '4columns'){ ?>
					<div class="column footer-widgets-block column-4">	
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-1' ); ?>
						</div><!-- col -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-2' ); ?>
						</div><!-- col -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-3' ); ?>
						</div><!-- col -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-4' ); ?>
						</div><!-- col -->
					</div><!-- col -->
				<?php } else { ?>
					<div class="column footer-contact-block">
						<?php dynamic_sidebar( 'footer-1' ); ?>	
					</div><!-- column -->
					<div class="column footer-widgets-block column-4">
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-2' ); ?>
						</div><!-- widget-column -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-3' ); ?>
						</div><!-- widget-column -->
						<div class="widget-col">
							<?php dynamic_sidebar( 'footer-4' ); ?>
						</div><!-- widget-column -->
						
						<?php $footersocial = get_theme_mod('grogin_footer_social_list'); ?>
						<?php $appimage = get_theme_mod('grogin_footer_app_image'); ?>
						<?php if($footersocial || $appimage){ ?>
							<div class="widget-col">
								<div class="widget">
								  <h4 class="widget-title"><?php echo esc_html(get_theme_mod('grogin_footer_app_title')); ?></h4>
								  <div class="widget-body">
								  
									<?php if($appimage){ ?>
										<div class="app-buttons">
										<?php foreach($appimage as $app){ ?>
											<div class="app-button">
												<a href="<?php echo esc_url($app['app_url']); ?>">
													<img src="<?php echo esc_url( grogin_get_image($app['app_image'])); ?>" alt="<?php esc_attr_e('app','grogin'); ?>"/>
												</a>
												<p><?php echo esc_html($app['app_image_title']); ?></p>
											</div><!-- app-button -->
										<?php } ?>
										</div><!-- app-buttons -->
									<?php } ?>
									
									<?php if(!empty($footersocial)){ ?>
										<span class="d-block text-12 mt-30 sm-mt-50 mb-10"><?php echo esc_html(get_theme_mod('grogin_footer_social_list_title')); ?></span>
										<div class="site-social">
										
										  <ul>
											<?php foreach($footersocial as $f){ ?>
												<li><a href="<?php echo esc_url($f['social_url']); ?>" class="filled white md <?php echo esc_attr($f['social_icon']); ?>"><i class="klb-social-icon-<?php echo esc_attr($f['social_icon']); ?>"></i></a></li>
											<?php } ?>
										  </ul>
										  
										</div><!-- site-social -->
									<?php } ?>
									
								  </div><!-- widget-body -->
								</div><!-- widget -->
							</div><!-- widget-col -->
						<?php } ?>	
					</div><!-- column -->
				<?php } ?>
					
			</div><!-- footer-inner -->
        </div><!-- container -->
      </div><!-- footer-row -->
    <?php } ?>
	
    <div class="footer-row footer-copyright get-mobile-nav-height">
        <div class="container">
			<div class="footer-inner">
				<div class="column">
					<div class="site-copyright">
						<?php if(get_theme_mod( 'grogin_copyright' )){ ?>
							<p class="text-12 fw-medium lh-base mb-0"><?php echo grogin_sanitize_data(get_theme_mod( 'grogin_copyright' )); ?></p>
						<?php } else { ?>
							<p class="text-12 fw-medium lh-base mb-0"><?php esc_html_e('Copyright 2024.KlbTheme . All rights reserved','grogin'); ?></p>
						<?php } ?>
					</div>          
			  
					<?php $footerpayment = get_theme_mod('grogin_footer_payment_image',0); ?>
						<?php if($footerpayment == 1){ ?>
					
						<?php  $footer_payment_multicheck = get_theme_mod('grogin_footer_payment',array( 'visa', 'mastercard', 'paypal', 'skrill', 'klarna')); ?>
						
						<div class="site-payment-cards mt-8 sm-mt-16">
							<ul>
								<?php if(in_array('visa', $footer_payment_multicheck)){ ?>
								  <li>
									<svg width="36" height="13" viewBox="0 0 36 13" fill="none" xmlns="http://www.w3.org/2000/svg">
									  <g clip-path="url(#clip0_304_9928)">
									  <path d="M31.6 4.9002L32.2 8.1002H29.8L31 5.0002L31.2 4.4002L31.3 3.9002C31.3 4.0002 31.6 4.9002 31.6 4.9002ZM8.89999 12.0002L13.3 1.1002H10.3L7.59999 8.6002L7.29999 7.0002L6.29999 2.0002C6.19999 1.4002 5.69999 1.0002 4.89999 1.0002H0.399988L0.299988 1.2002C1.49999 1.4002 2.39999 1.8002 3.29999 2.4002L5.89999 12.1002H8.99999L8.89999 12.0002ZM15.6 12.0002L17.4 1.1002H14.6L12.8 12.2002H15.6V12.0002ZM25.7 8.5002C25.7 7.3002 24.9 6.3002 23.3 5.4002C22.1 4.9002 21.5 4.5002 21.5 4.1002C21.5 3.5002 22.1 3.2002 23.3 3.2002C24 3.2002 24.7 3.2002 25.3 3.7002H25.7L26 1.2002C25.1 0.800195 24.3 0.700195 23.4 0.700195C22.5 0.700195 21.7 0.900195 21 1.2002C20.3 1.5002 19.7 1.9002 19.2 2.5002C18.8 3.1002 18.6 3.7002 18.6 4.4002C18.6 5.6002 19.4 6.6002 21.2 7.5002C22.1 8.0002 22.6 8.40019 22.6 8.80019C22.6 9.50019 22 10.0002 20.9 10.0002C20 10.0002 19 9.8002 18.2 9.4002L17.8 9.2002L17.3 11.6002C18.3 12.0002 19.4 12.3002 20.5 12.3002C21.8 12.4002 23 12.0002 24 11.4002C25.2 10.6002 25.7 9.6002 25.7 8.5002ZM35.7 12.0002L33.4 1.1002H31.2C30.5 1.1002 30 1.3002 29.8 2.0002L25.5 12.2002H28.5L29 10.6002H32.8L33.2 12.3002H35.8V12.0002H35.7Z" fill="url(#paint0_linear_304_9928)"/>
									  </g>
									  <defs>
									  <linearGradient id="paint0_linear_304_9928" x1="1.58189" y1="6.5086" x2="35.2449" y2="6.5086" gradientUnits="userSpaceOnUse">
									  <stop stop-color="#2C3572"/>
									  <stop offset="1" stop-color="#3C62AB"/>
									  </linearGradient>
									  <clipPath id="clip0_304_9928">
									  <rect width="36" height="12" fill="white" transform="translate(0 0.60022)"/>
									  </clipPath>
									  </defs>
									</svg>                  
								  </li>
								<?php } ?>
								<?php if(in_array('mastercard', $footer_payment_multicheck)){ ?>
								  <li>
									<svg width="24" height="15" viewBox="0 0 24 15" fill="none" xmlns="http://www.w3.org/2000/svg">
									  <g clip-path="url(#clip0_304_9930)">
									  <path d="M7.4 15.0002C11.4869 15.0002 14.8 11.6871 14.8 7.6002C14.8 3.51329 11.4869 0.200195 7.4 0.200195C3.31309 0.200195 0 3.51329 0 7.6002C0 11.6871 3.31309 15.0002 7.4 15.0002Z" fill="#DD3D31"/>
									  <path d="M16.6 15.0002C20.6869 15.0002 24 11.6871 24 7.6002C24 3.51329 20.6869 0.200195 16.6 0.200195C12.5131 0.200195 9.20001 3.51329 9.20001 7.6002C9.20001 11.6871 12.5131 15.0002 16.6 15.0002Z" fill="#EEB046"/>
									  <path fill-rule="evenodd" clip-rule="evenodd" d="M12 13.5002C15.2 11.0002 15.8 6.30017 13.3 3.10017C12.9 2.60017 12.5 2.20017 12 1.80017C8.79997 4.30017 8.19997 9.00017 10.7 12.2002C11.1 12.7002 11.5 13.1002 12 13.5002Z" fill="#EF7D2F"/>
									  </g>
									  <defs>
									  <clipPath id="clip0_304_9930">
									  <rect width="24" height="14.8" fill="white" transform="translate(0 0.200195)"/>
									  </clipPath>
									  </defs>
									</svg>                  
								  </li>
								<?php } ?>
								<?php if(in_array('paypal', $footer_payment_multicheck)){ ?>
									<li>
										<svg width="53" height="15" viewBox="0 0 53 15" fill="none" xmlns="http://www.w3.org/2000/svg">
										  <g clip-path="url(#clip0_304_9934)">
										  <path d="M6.63747 0.712753H2.61247C2.33747 0.712753 2.09997 0.912744 2.06247 1.18774L0.437472 11.4877C0.399972 11.6877 0.562472 11.8752 0.774972 11.8752H2.69997C2.97497 11.8752 3.21247 11.6753 3.24997 11.4003L3.68747 8.62524C3.72497 8.35024 3.96247 8.15025 4.23747 8.15025H5.49997C8.14997 8.15025 9.67497 6.87526 10.075 4.32526C10.25 3.21276 10.0875 2.33775 9.56247 1.72525C8.98747 1.07525 7.97497 0.712753 6.63747 0.712753ZM7.09997 4.48775C6.87497 5.92525 5.77497 5.92525 4.71247 5.92525H4.09997L4.52497 3.23775C4.54997 3.07525 4.68747 2.95026 4.84997 2.95026H5.12497C5.84997 2.95026 6.53747 2.95025 6.88747 3.36275C7.11247 3.61275 7.17497 3.97525 7.09997 4.48775Z" fill="#283B82"/>
										  <path d="M18.65 4.43774H16.725C16.5625 4.43774 16.425 4.56275 16.4 4.72525L16.3125 5.26276L16.175 5.06274C15.7625 4.46274 14.825 4.25024 13.9 4.25024C11.775 4.25024 9.9625 5.86274 9.6 8.12524C9.4125 9.25024 9.675 10.3253 10.3125 11.0878C10.9 11.7753 11.7375 12.0627 12.7375 12.0627C14.45 12.0627 15.4 10.9628 15.4 10.9628L15.3125 11.5002C15.275 11.7002 15.4375 11.8878 15.6375 11.8878H17.375C17.65 11.8878 17.8875 11.6878 17.925 11.4128L18.9625 4.82526C19.0125 4.62526 18.85 4.43774 18.65 4.43774ZM15.9625 8.18774C15.775 9.28774 14.9 10.0253 13.7875 10.0253C13.225 10.0253 12.7875 9.85024 12.5 9.50024C12.2125 9.16274 12.1125 8.68775 12.2 8.15025C12.375 7.06275 13.2625 6.30025 14.3625 6.30025C14.9125 6.30025 15.35 6.48776 15.65 6.82526C15.925 7.16276 16.05 7.65024 15.9625 8.18774Z" fill="#283B82"/>
										  <path d="M28.9 4.43771H26.9625C26.775 4.43771 26.6 4.52521 26.5 4.68771L23.8375 8.61272L22.7125 4.83772C22.6375 4.60022 22.425 4.43771 22.175 4.43771H20.275C20.05 4.43771 19.8875 4.66271 19.9625 4.87521L22.0875 11.1252L20.0875 13.9502C19.925 14.1752 20.0875 14.4752 20.3625 14.4752H22.3C22.4875 14.4752 22.65 14.3877 22.7625 14.2377L29.2 4.95023C29.325 4.73773 29.1625 4.43771 28.9 4.43771Z" fill="#283B82"/>
										  <path d="M35.3 0.712753H31.275C31 0.712753 30.7625 0.912744 30.725 1.18774L29.1 11.4877C29.0625 11.6877 29.225 11.8752 29.425 11.8752H31.5C31.6875 11.8752 31.85 11.7377 31.8875 11.5502L32.35 8.62524C32.3875 8.35024 32.625 8.15025 32.9 8.15025H34.175C36.825 8.15025 38.35 6.87526 38.75 4.32526C38.925 3.21276 38.7625 2.33775 38.2375 1.72525C37.6625 1.07525 36.65 0.712753 35.3 0.712753ZM35.7625 4.48775C35.5375 5.92525 34.4375 5.92525 33.375 5.92525H32.775L33.2 3.23775C33.225 3.07525 33.3625 2.95026 33.525 2.95026H33.8C34.525 2.95026 35.2125 2.95025 35.5625 3.36275C35.775 3.61275 35.8375 3.97525 35.7625 4.48775Z" fill="#469BDB"/>
										  <path d="M47.3125 4.43774H45.3875C45.225 4.43774 45.0875 4.56275 45.0625 4.72525L44.975 5.26276L44.8375 5.06274C44.425 4.46274 43.4875 4.25024 42.5625 4.25024C40.4375 4.25024 38.625 5.86274 38.2625 8.12524C38.075 9.25024 38.3375 10.3253 38.975 11.0878C39.5625 11.7753 40.4 12.0627 41.4 12.0627C43.1125 12.0627 44.0625 10.9628 44.0625 10.9628L43.975 11.5002C43.9375 11.7002 44.1 11.8878 44.3125 11.8878H46.05C46.325 11.8878 46.5625 11.6878 46.6 11.4128L47.6375 4.82526C47.675 4.62526 47.5125 4.43774 47.3125 4.43774ZM44.625 8.18774C44.4375 9.28774 43.5625 10.0253 42.45 10.0253C41.8875 10.0253 41.45 9.85024 41.1625 9.50024C40.875 9.16274 40.775 8.68775 40.8625 8.15025C41.0375 7.06275 41.925 6.30025 43.025 6.30025C43.575 6.30025 44.0125 6.48776 44.3125 6.82526C44.6 7.16276 44.7125 7.65024 44.625 8.18774Z" fill="#469BDB"/>
										  <path d="M49.575 1.00018L47.925 11.5002C47.8875 11.7002 48.05 11.8877 48.25 11.8877H49.9125C50.1875 11.8877 50.425 11.6877 50.4625 11.4127L52.0875 1.11269C52.125 0.912686 51.9625 0.725189 51.7625 0.725189H49.9C49.75 0.712689 49.6125 0.837683 49.575 1.00018Z" fill="#469BDB"/>
										  </g>
										  <defs>
										  <clipPath id="clip0_304_9934">
										  <rect width="52.5" height="14" fill="white" transform="translate(0 0.60022)"/>
										  </clipPath>
										  </defs>
										</svg>                  
									</li>
								<?php } ?>
								<?php if(in_array('skrill', $footer_payment_multicheck)){ ?>
									<li>
										<svg width="41" height="15" viewBox="0 0 41 15" fill="none" xmlns="http://www.w3.org/2000/svg">
										  <g clip-path="url(#clip0_304_9943)">
										  <path d="M29.3 4.00017C30.2 4.00017 30.9 3.30017 30.9 2.40017C30.9 1.50017 30.2 0.800171 29.3 0.800171C28.4 0.800171 27.7 1.50017 27.7 2.40017C27.6 3.30017 28.3 4.00017 29.3 4.00017C29.3 4.10017 29.3 4.10017 29.3 4.00017ZM16.7 4.90017C16.6 5.10017 16.1 6.60017 14.8 8.20017V1.50017L11.4 2.20017V14.3002H14.8V10.6002C15.8 12.1002 16.3 14.3002 16.3 14.3002H20.4C20 12.6002 18.2 9.50017 18.2 9.50017C19.3 8.10017 20.1 6.60017 20.6 5.00017L16.7 4.90017ZM25.7 4.80017C22.6 4.90017 21.1 6.30017 21.1 9.00017V14.3002H24.5V10.0002C24.5 8.40017 24.7 7.70017 26.7 7.60017V4.90017C26.3 4.80017 25.7 4.80017 25.7 4.80017ZM5.6 6.30017C5.2 6.30017 4.2 6.20017 4.2 5.30017C4.2 4.20017 5.6 4.20017 6.1 4.20017C7 4.20017 8.2 4.50017 9.1 4.70017C9.4 4.80017 9.7 4.90017 10 5.00017V2.20017H9.9C8.9 1.80017 7.7 1.50017 5.5 1.50017C1.8 1.50017 0.5 3.70017 0.5 5.60017C0.5 6.70017 1 9.20017 5.3 9.50017C5.7 9.50017 6.6 9.60017 6.6 10.5002C6.6 11.2002 5.8 11.7002 4.5 11.7002C3 11.7002 1.6 11.3002 0.8 11.0002V14.0002C2.1 14.3002 3.5 14.5002 5.2 14.5002C8.9 14.5002 10.5 12.4002 10.5 10.4002C10.5 8.00017 8.7 6.50017 5.6 6.30017ZM27.6 14.3002H30.9V4.90017H27.6V14.3002ZM37.2 2.10017V14.3002H40.5V1.50017L37.2 2.10017ZM32.3 2.10017L35.6 1.50017V14.3002H32.3V2.10017Z" fill="#862565"/>
										  </g>
										  <defs>
										  <clipPath id="clip0_304_9943">
										  <rect width="40" height="14" fill="white" transform="translate(0.5 0.60022)"/>
										  </clipPath>
										  </defs>
										</svg>                  
									</li>
								<?php } ?>
								<?php if(in_array('klarna', $footer_payment_multicheck)){ ?>
									<li>
										<svg width="64" height="15" viewBox="0 0 64 15" fill="none" xmlns="http://www.w3.org/2000/svg">
										  <g clip-path="url(#clip0_304_9945)">
										  <path d="M11.6 0.60022H8.59995C8.59995 3.10022 7.39995 5.40022 5.39995 6.90022L4.19995 7.90022L8.89995 14.3002H12.8L8.39995 8.40022C10.5 6.40022 11.6 3.60022 11.6 0.60022Z" fill="black"/>
										  <path d="M3.79995 0.60022H0.699951V14.3002H3.79995V0.60022Z" fill="black"/>
										  <path d="M16.7 0.60022H13.7V14.3002H16.7V0.60022Z" fill="black"/>
										  <path d="M42.5999 4.60022C41.4999 4.60022 40.3999 4.90022 39.6999 5.90022V4.90022H36.8999V14.3002H39.7999V9.30022C39.7999 7.90022 40.7999 7.20022 41.8999 7.20022C43.0999 7.20022 43.8999 7.90022 43.8999 9.30022V14.3002H46.6999V8.30022C46.5999 6.10022 44.8999 4.60022 42.5999 4.60022Z" fill="black"/>
										  <path d="M25.5999 4.90022V5.50022C24.7999 4.90022 23.7999 4.60022 22.7999 4.60022C19.9999 4.60022 17.7999 6.80022 17.7999 9.60022C17.7999 12.4002 19.9999 14.6002 22.7999 14.6002C23.7999 14.6002 24.7999 14.3002 25.5999 13.7002V14.3002H28.3999V4.90022H25.5999ZM22.9999 12.0002C21.5999 12.0002 20.3999 10.9002 20.3999 9.60022C20.3999 8.30022 21.4999 7.20022 22.9999 7.20022C24.4999 7.20022 25.5999 8.30022 25.5999 9.60022C25.5999 10.9002 24.3999 12.0002 22.9999 12.0002Z" fill="black"/>
										  <path d="M32.7999 6.10027V4.90027H29.8999V14.3003H32.7999V9.90027C32.7999 8.40027 34.3999 7.60027 35.4999 7.60027V4.90027C34.3999 4.90027 33.3999 5.30027 32.7999 6.10027Z" fill="black"/>
										  <path d="M55.4 4.90022V5.50022C54.6 4.90022 53.7 4.60022 52.6 4.60022C49.8 4.60022 47.6 6.80022 47.6 9.60022C47.6 12.4002 49.8 14.6002 52.6 14.6002C53.6 14.6002 54.6 14.3002 55.4 13.7002V14.3002H58.2V4.90022H55.4ZM52.9 12.0002C51.5 12.0002 50.3 10.9002 50.3 9.60022C50.3 8.30022 51.4 7.20022 52.9 7.20022C54.3 7.20022 55.5 8.30022 55.5 9.60022C55.4 10.9002 54.3 12.0002 52.9 12.0002Z" fill="black"/>
										  <path d="M60.4 5.10027C60.4 5.00027 60.3 4.90027 60.2 4.90027H59.9V5.60027H60V5.40027H60.1L60.3 5.60027H60.4L60.3 5.30027C60.4 5.30027 60.4 5.20027 60.4 5.10027ZM60.2 5.20027H60.1V5.00027H60.2C60.3 5.00027 60.3 5.00027 60.3 5.10027C60.3 5.20027 60.3 5.20027 60.2 5.20027Z" fill="black"/>
										  <path d="M60.2 4.60022C59.8 4.60022 59.5 4.90022 59.5 5.30022C59.5 5.70022 59.8 6.00022 60.2 6.00022C60.6 6.00022 60.9 5.70022 60.9 5.30022C60.9 4.90022 60.5 4.60022 60.2 4.60022ZM60.2 5.80022C59.9 5.80022 59.7 5.60022 59.7 5.20022C59.7 4.90022 59.9 4.60022 60.2 4.60022C60.5 4.60022 60.7 4.80022 60.7 5.20022C60.7 5.60022 60.4 5.80022 60.2 5.80022Z" fill="black"/>
										  <path d="M61.3 11.0002C60.3 11.0002 59.5 11.8002 59.5 12.8002C59.5 13.8002 60.3 14.6002 61.3 14.6002C62.3 14.6002 63.1 13.8002 63.1 12.8002C63.1 11.7002 62.3 11.0002 61.3 11.0002Z" fill="black"/>
										  </g>
										  <defs>
										  <clipPath id="clip0_304_9945">
										  <rect width="62.7" height="14" fill="white" transform="translate(0.5 0.60022)"/>
										  </clipPath>
										  </defs>
										</svg>                  
									</li>
								<?php } ?>	
							</ul>
						</div><!-- site-payment-cards -->
					<?php } ?>	
				</div><!-- column -->
           
			   <div class="column footer-copyright-menu">
					<nav class="site-menu footer-menu">
					<?php 
					wp_nav_menu(array(
					'theme_location' => 'footer-menu',
					'container' => '',
					'fallback_cb' => 'show_top_menu',
					'menu_id' => '',
					'menu_class' => 'menu',
					'echo' => true,
					"walker" => '',
					'depth' => 0 
					));
					?>
					</nav>
				</div><!-- column -->
			</div><!-- footer-inner -->
        </div><!-- container -->
    </div><!-- footer-row -->
</footer>